/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.MacawsFurnitures;
import com.mcwfurnitures.kikoz.storage.CouchEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Couch
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<CouchShape> SHAPE = EnumProperty.func_177709_a((String)"shape", CouchShape.class);
    private static final VoxelShape W_SINGLE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)2.0, (double)16.0), Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)3.0), Block.func_208617_a((double)1.0, (double)7.0, (double)12.0, (double)15.0, (double)17.0, (double)16.0), Block.func_208617_a((double)0.0, (double)7.0, (double)0.0, (double)4.0, (double)11.0, (double)15.0), Block.func_208617_a((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)11.0, (double)15.0), Block.func_208617_a((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)7.0, (double)16.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)3.0)});
    private static final VoxelShape W_MIDDLE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
    private static final VoxelShape W_LEFT = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)1.0, (double)7.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), Block.func_208617_a((double)0.0, (double)7.0, (double)0.0, (double)4.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)3.0)});
    private static final VoxelShape W_RIGHT = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)3.0), Block.func_208617_a((double)0.0, (double)7.0, (double)12.0, (double)15.0, (double)17.0, (double)16.0), Block.func_208617_a((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)});
    private static final VoxelShape W_CORNER = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), Block.func_208617_a((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)17.0, (double)12.0), Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)});
    private static final VoxelShape N_SINGLE = MacawsFurnitures.calculateShapes(Direction.EAST, W_SINGLE);
    private static final VoxelShape N_MIDDLE = MacawsFurnitures.calculateShapes(Direction.EAST, W_MIDDLE);
    private static final VoxelShape N_LEFT = MacawsFurnitures.calculateShapes(Direction.EAST, W_LEFT);
    private static final VoxelShape N_RIGHT = MacawsFurnitures.calculateShapes(Direction.EAST, W_RIGHT);
    private static final VoxelShape N_CORNER = MacawsFurnitures.calculateShapes(Direction.EAST, W_CORNER);
    private static final VoxelShape S_SINGLE = MacawsFurnitures.calculateShapes(Direction.WEST, W_SINGLE);
    private static final VoxelShape S_MIDDLE = MacawsFurnitures.calculateShapes(Direction.WEST, W_MIDDLE);
    private static final VoxelShape S_LEFT = MacawsFurnitures.calculateShapes(Direction.WEST, W_LEFT);
    private static final VoxelShape S_RIGHT = MacawsFurnitures.calculateShapes(Direction.WEST, W_RIGHT);
    private static final VoxelShape S_CORNER = MacawsFurnitures.calculateShapes(Direction.WEST, W_CORNER);
    private static final VoxelShape E_SINGLE = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_SINGLE);
    private static final VoxelShape E_MIDDLE = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_MIDDLE);
    private static final VoxelShape E_LEFT = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_LEFT);
    private static final VoxelShape E_RIGHT = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_RIGHT);
    private static final VoxelShape E_CORNER = MacawsFurnitures.calculateShapes(Direction.SOUTH, W_CORNER);

    public Couch(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)((Object)CouchShape.SINGLE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SHAPE, FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return CouchEntity.create(level, pos, 0.7, player);
    }

    private BlockState StairState(BlockState state, IWorld access, BlockPos pos) {
        boolean north = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean east = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean south = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean west = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        Direction facingDirection = (Direction)state.func_177229_b((Property)FACING);
        CouchShape connection = this.getCouchShape(facingDirection, north, east, south, west);
        return (BlockState)((BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)connection))).func_206870_a((Property)FACING, (Comparable)facingDirection);
    }

    private CouchShape getCouchShape(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        switch (facing) {
            case NORTH: {
                if (!north && !south) {
                    return CouchShape.SINGLE;
                }
                if (north && south) {
                    return CouchShape.MIDDLE;
                }
                if (!north && south && !east && !west) {
                    return CouchShape.LEFT;
                }
                if (north && !south && !east && !west) {
                    return CouchShape.RIGHT;
                }
                if (north && !south && east) {
                    return CouchShape.LEFT_CORNER;
                }
                if (north || !south || !east) break;
                return CouchShape.RIGHT_CORNER;
            }
            case EAST: {
                if (!east && !west) {
                    return CouchShape.SINGLE;
                }
                if (east && west) {
                    return CouchShape.MIDDLE;
                }
                if (!east && west && !north && !south) {
                    return CouchShape.LEFT;
                }
                if (east && !west && !north && !south) {
                    return CouchShape.RIGHT;
                }
                if (east && !west && south) {
                    return CouchShape.LEFT_CORNER;
                }
                if (east || !west || !south) break;
                return CouchShape.RIGHT_CORNER;
            }
            case SOUTH: {
                if (!north && !south) {
                    return CouchShape.SINGLE;
                }
                if (north && south) {
                    return CouchShape.MIDDLE;
                }
                if (north && !south && !east && !west) {
                    return CouchShape.LEFT;
                }
                if (!north && south && !east && !west) {
                    return CouchShape.RIGHT;
                }
                if (north && !south && west) {
                    return CouchShape.RIGHT_CORNER;
                }
                if (north || !south || !west) break;
                return CouchShape.LEFT_CORNER;
            }
            case WEST: {
                if (!east && !west) {
                    return CouchShape.SINGLE;
                }
                if (east && west) {
                    return CouchShape.MIDDLE;
                }
                if (east && !west && !north && !south) {
                    return CouchShape.LEFT;
                }
                if (!east && west && !north && !south) {
                    return CouchShape.RIGHT;
                }
                if (east && !west && north) {
                    return CouchShape.RIGHT_CORNER;
                }
                if (east || !west || !north) break;
                return CouchShape.LEFT_CORNER;
            }
        }
        return CouchShape.SINGLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        CouchShape shape = (CouchShape)((Object)state.func_177229_b(SHAPE));
        switch (facing) {
            case NORTH: {
                switch (shape) {
                    case SINGLE: {
                        return N_SINGLE;
                    }
                    case MIDDLE: {
                        return N_MIDDLE;
                    }
                    case LEFT: {
                        return N_LEFT;
                    }
                    case RIGHT: {
                        return N_RIGHT;
                    }
                    case LEFT_CORNER: {
                        return N_CORNER;
                    }
                    case RIGHT_CORNER: {
                        return E_CORNER;
                    }
                }
                return N_SINGLE;
            }
            case EAST: {
                switch (shape) {
                    case SINGLE: {
                        return E_SINGLE;
                    }
                    case MIDDLE: {
                        return E_MIDDLE;
                    }
                    case LEFT: {
                        return E_LEFT;
                    }
                    case RIGHT: {
                        return E_RIGHT;
                    }
                    case LEFT_CORNER: {
                        return E_CORNER;
                    }
                    case RIGHT_CORNER: {
                        return S_CORNER;
                    }
                }
                return E_SINGLE;
            }
            case SOUTH: {
                switch (shape) {
                    case SINGLE: {
                        return S_SINGLE;
                    }
                    case MIDDLE: {
                        return S_MIDDLE;
                    }
                    case LEFT: {
                        return S_LEFT;
                    }
                    case RIGHT: {
                        return S_RIGHT;
                    }
                    case LEFT_CORNER: {
                        return S_CORNER;
                    }
                    case RIGHT_CORNER: {
                        return W_CORNER;
                    }
                }
                return S_SINGLE;
            }
            case WEST: {
                switch (shape) {
                    case SINGLE: {
                        return W_SINGLE;
                    }
                    case MIDDLE: {
                        return W_MIDDLE;
                    }
                    case LEFT: {
                        return W_LEFT;
                    }
                    case RIGHT: {
                        return W_RIGHT;
                    }
                    case LEFT_CORNER: {
                        return W_CORNER;
                    }
                    case RIGHT_CORNER: {
                        return N_CORNER;
                    }
                }
                return W_SINGLE;
            }
        }
        return N_SINGLE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean p_220082_5_) {
        if (!statetwo.func_203425_a(state.func_177230_c())) {
            level.func_180501_a(pos, this.StairState(state, (IWorld)level, pos), 2);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld level, BlockPos pos, BlockPos postwo) {
        return this.StairState(state, level, pos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext contx) {
        BlockPos pos = contx.func_195995_a().func_177977_b();
        World world = contx.func_195991_k();
        Direction facingDirection = contx.func_195992_f().func_176746_e();
        return (BlockState)this.StairState(super.func_196258_a(contx), (IWorld)contx.func_195991_k(), contx.func_195995_a()).func_206870_a((Property)FACING, (Comparable)facingDirection);
    }

    public static enum CouchShape implements IStringSerializable
    {
        SINGLE("single"),
        LEFT("left"),
        MIDDLE("middle"),
        RIGHT("right"),
        LEFT_CORNER("left_corner"),
        RIGHT_CORNER("right_corner");

        private final String name;

        private CouchShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

