/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.objects.FurnitureObjectNonFaceable;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Desk
extends FurnitureObjectNonFaceable {
    public static final DirectionProperty FACING_TWO_DIRECTIONAL = DirectionProperty.func_196962_a((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.func_177706_a((String)"connection", ConnectionStatus.class, (Enum[])new ConnectionStatus[]{ConnectionStatus.SINGLE, ConnectionStatus.MIDDLE, ConnectionStatus.LEFT, ConnectionStatus.RIGHT});
    protected static final VoxelShape NORTH_BASE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0)});
    protected static final VoxelShape NORTH_MIDDLE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH_RIGHT = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape NORTH_LEFT = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape EAST_BASE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)1.1, (double)0.0, (double)0.0, (double)3.1, (double)14.0, (double)16.1), Block.func_208617_a((double)13.1, (double)0.0, (double)0.0, (double)15.1, (double)14.0, (double)16.1)});
    protected static final VoxelShape EAST_MIDDLE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST_RIGHT = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.1, (double)14.0, (double)0.0, (double)16.1, (double)16.0, (double)16.1), (VoxelShape)Block.func_208617_a((double)13.1, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0));
    protected static final VoxelShape EAST_LEFT = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape)Block.func_208617_a((double)1.1, (double)0.0, (double)0.0, (double)3.1, (double)14.0, (double)16.1));

    public Desk(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING_TWO_DIRECTIONAL, (Comparable)Direction.NORTH)).func_206870_a(CONNECTION, (Comparable)((Object)ConnectionStatus.SINGLE)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        ConnectionStatus connectionStatus = (ConnectionStatus)((Object)state.func_177229_b(CONNECTION));
        switch ((Direction)state.func_177229_b((Property)FACING_TWO_DIRECTIONAL)) {
            case NORTH: {
                if (connectionStatus == ConnectionStatus.MIDDLE) {
                    return NORTH_MIDDLE;
                }
                if (connectionStatus == ConnectionStatus.LEFT) {
                    return NORTH_LEFT;
                }
                if (connectionStatus == ConnectionStatus.RIGHT) {
                    return NORTH_RIGHT;
                }
                return NORTH_BASE;
            }
        }
        if (connectionStatus == ConnectionStatus.MIDDLE) {
            return EAST_MIDDLE;
        }
        if (connectionStatus == ConnectionStatus.LEFT) {
            return EAST_LEFT;
        }
        if (connectionStatus == ConnectionStatus.RIGHT) {
            return EAST_RIGHT;
        }
        return EAST_BASE;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING_TWO_DIRECTIONAL, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING_TWO_DIRECTIONAL)));
    }

    private BlockState TableState(BlockState state, IWorld world, BlockPos pos) {
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.func_177229_b((Property)FACING_TWO_DIRECTIONAL), north, east, south, west);
        return (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        if (facing == Direction.NORTH) {
            if (north && south && !east && !west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && south && !east && !west) {
                return ConnectionStatus.RIGHT;
            }
            if (north && !south && !east && !west) {
                return ConnectionStatus.LEFT;
            }
        }
        if (facing == Direction.EAST) {
            if (!north && !south && east && west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && !south && east && !west) {
                return ConnectionStatus.LEFT;
            }
            if (!north && !south && !east && west) {
                return ConnectionStatus.RIGHT;
            }
        }
        return ConnectionStatus.SINGLE;
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean bolean) {
        Direction currentFacing = (Direction)state.func_177229_b((Property)FACING_TWO_DIRECTIONAL);
        BlockState defaultState = (BlockState)this.func_176223_P().func_206870_a((Property)FACING_TWO_DIRECTIONAL, (Comparable)currentFacing);
        level.func_180501_a(pos, this.TableState(defaultState, (IWorld)level, pos), 2);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING_TWO_DIRECTIONAL, CONNECTION});
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        this.TableState(state, (IWorld)level, pos);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld level, BlockPos pos, BlockPos postwo) {
        return this.TableState(state, level, pos);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction deskFacing;
        Direction playerFacing = context.func_195992_f();
        switch (playerFacing) {
            case NORTH: {
                deskFacing = Direction.EAST;
                break;
            }
            case SOUTH: {
                deskFacing = Direction.EAST;
                break;
            }
            case EAST: {
                deskFacing = Direction.NORTH;
                break;
            }
            case WEST: {
                deskFacing = Direction.NORTH;
                break;
            }
            default: {
                deskFacing = Direction.NORTH;
            }
        }
        return (BlockState)this.TableState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)FACING_TWO_DIRECTIONAL, (Comparable)deskFacing);
    }

    public void placeAt(IWorld level, BlockPos pos, int number) {
        level.func_180501_a(pos, this.func_176223_P(), number);
    }

    public static enum ConnectionStatus implements IStringSerializable
    {
        SINGLE("single"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

