/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.init.TileEntityInit;
import com.mcwfurnitures.kikoz.objects.FurnitureObject;
import com.mcwfurnitures.kikoz.storage.FurnitureTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TallFurniture
extends FurnitureObject {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.func_177706_a((String)"connection", ConnectionStatus.class, (Enum[])new ConnectionStatus[]{ConnectionStatus.BASE, ConnectionStatus.TOP, ConnectionStatus.MIDDLE, ConnectionStatus.BOTTOM});
    protected static final VoxelShape EW = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NS = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public TallFurniture(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NS;
            }
            case SOUTH: {
                return NS;
            }
            case WEST: {
                return EW;
            }
        }
        return EW;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.FURNITURE_CHEST.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = worldIn.func_175625_s(pos)) instanceof FurnitureTileEntity) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((FurnitureTileEntity)te).func_190576_q());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item != this.func_199767_j()) {
            if (!worldIn.func_201670_d()) {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof FurnitureTileEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntity)tile), (BlockPos)pos);
                    ((FurnitureTileEntity)tile).func_174889_b(player);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    private BlockState TableState(BlockState state, IWorld world, BlockPos pos) {
        boolean above = world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && state.func_177229_b((Property)FACING) == world.func_180495_p(pos.func_177984_a()).func_177229_b((Property)FACING);
        boolean below = world.func_180495_p(pos.func_177977_b()).func_177230_c() == this && state.func_177229_b((Property)FACING) == world.func_180495_p(pos.func_177977_b()).func_177229_b((Property)FACING);
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.func_177229_b((Property)FACING), above, below);
        return (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean above, boolean below) {
        if (above && below) {
            return ConnectionStatus.MIDDLE;
        }
        if (above && !below) {
            return ConnectionStatus.BOTTOM;
        }
        if (!above && below) {
            return ConnectionStatus.TOP;
        }
        return ConnectionStatus.BASE;
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean p_220082_5_) {
        if (!statetwo.func_203425_a(state.func_177230_c())) {
            this.TableState(state, (IWorld)level, pos);
        }
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, CONNECTION});
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld level, BlockPos pos, BlockPos postwo) {
        return this.TableState(state, level, pos);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.TableState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public void placeAt(IWorld level, BlockPos pos, int num) {
        level.func_180501_a(pos, this.func_176223_P(), num);
    }

    public static enum ConnectionStatus implements IStringSerializable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

