/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.counters;

import com.mcwfurnitures.kikoz.objects.counters.Counter;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;

public class SinkCounter
extends Counter {
    public static final BooleanProperty WATER = BooleanProperty.func_177716_a((String)"water");
    protected static final VoxelShape BASE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public SinkCounter(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        boolean hasWater = (Boolean)state.func_177229_b((Property)WATER);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (item == Items.field_151131_as && !hasWater) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            level.func_180501_a(pos, state, 2);
            level.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_151133_ar && hasWater) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            level.func_180501_a(pos, state, 2);
            itemstack.func_190918_g(1);
            level.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_151069_bo && hasWater) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            level.func_180501_a(pos, state, 2);
            level.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
            ItemStack waterBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, waterBottle);
                } else if (!player.field_71071_by.func_70441_a(waterBottle)) {
                    player.func_71019_a(waterBottle, false);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (!level.field_72995_K) {
            BlockState newState = (BlockState)state.func_235896_a_((Property)WATER);
            level.func_180501_a(pos, newState, 3);
            level.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        if (!hasWater) {
            double baseX = (double)pos.func_177958_n() + 0.5;
            double baseZ = (double)pos.func_177952_p() + 0.5;
            double offset = 0.1;
            switch (facing) {
                case NORTH: {
                    baseZ -= offset;
                }
                case SOUTH: {
                    baseZ += offset;
                }
                case EAST: {
                    baseX += offset;
                }
                case WEST: {
                    baseX -= offset;
                }
            }
            for (int i = 0; i < 20; ++i) {
                double y = (double)(pos.func_177956_o() + 1) - (double)i * 0.001;
                level.func_195594_a((IParticleData)ParticleTypes.field_218425_n, baseX, y, baseZ, 0.0, -1.0E-4, 0.0);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATER});
    }
}

