/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.storage;

import com.mcwfurnitures.kikoz.init.SoundsInit;
import com.mcwfurnitures.kikoz.init.TileEntityInit;
import com.mcwfurnitures.kikoz.objects.TallFurniture;
import com.mcwfurnitures.kikoz.objects.bookshelves.BookCabinet;
import com.mcwfurnitures.kikoz.objects.bookshelves.BookCabinetHinge;
import com.mcwfurnitures.kikoz.objects.cabinets.Cabinet;
import com.mcwfurnitures.kikoz.objects.cabinets.CabinetHinge;
import com.mcwfurnitures.kikoz.objects.counters.CupboardCounter;
import com.mcwfurnitures.kikoz.storage.FurnitureContainer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FurnitureTileEntity
extends LockableLootTileEntity {
    private NonNullList<ItemStack> chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    protected int numPlayersUsing;
    private IItemHandlerModifiable items = this.createHandler();
    private LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);

    public FurnitureTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.items = this.createHandler();
        this.itemHandler = LazyOptional.of(() -> this.items);
    }

    public FurnitureTileEntity() {
        this((TileEntityType)TileEntityInit.FURNITURE_CHEST.get());
    }

    public int func_70302_i_() {
        return 27;
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.chestContents;
    }

    public void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.chestContents = itemsIn;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.furniture_chest");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new FurnitureContainer(id, player, this);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.chestContents);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(nbt)) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.chestContents);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.signalOpenCount();
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                BlockState state = this.func_195044_w();
                BlockPos pos = this.func_174877_v();
                SoundEvent sound = state.func_177230_c() instanceof TallFurniture || state.func_177230_c() instanceof BookCabinet || state.func_177230_c() instanceof BookCabinetHinge || state.func_177230_c() instanceof Cabinet || state.func_177230_c() instanceof CabinetHinge || state.func_177230_c() instanceof CupboardCounter ? (SoundEvent)SoundsInit.CABINET_OPEN.get() : (SoundEvent)SoundsInit.DRAWER_OPEN.get();
                this.playSound(this.field_145850_b, pos, sound);
            }
        }
    }

    private void playSound(World world, BlockPos pos, SoundEvent sound) {
        if (world == null || world.field_72995_K) {
            return;
        }
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        world.func_184148_a(null, x, y, z, sound, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.signalOpenCount();
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                BlockState state = this.func_195044_w();
                BlockPos pos = this.func_174877_v();
                SoundEvent sound = state.func_177230_c() instanceof TallFurniture || state.func_177230_c() instanceof BookCabinet || state.func_177230_c() instanceof BookCabinetHinge || state.func_177230_c() instanceof Cabinet || state.func_177230_c() instanceof CabinetHinge || state.func_177230_c() instanceof CupboardCounter ? (SoundEvent)SoundsInit.CABINET_CLOSE.get() : (SoundEvent)SoundsInit.DRAWER_CLOSE.get();
                this.playSound(this.field_145850_b, pos, sound);
            }
        }
    }

    protected void signalOpenCount() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof TallFurniture) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public static int getOpenCount(IBlockReader reader, BlockPos pos) {
        TileEntity tileentity;
        BlockState blockstate = reader.func_180495_p(pos);
        if (blockstate.hasTileEntity() && (tileentity = reader.func_175625_s(pos)) instanceof FurnitureTileEntity) {
            return ((FurnitureTileEntity)tileentity).numPlayersUsing;
        }
        return 0;
    }

    public static void swapContents(FurnitureTileEntity te, FurnitureTileEntity otherTe) {
        NonNullList<ItemStack> list = te.func_190576_q();
        te.func_199721_a(otherTe.func_190576_q());
        otherTe.func_199721_a(list);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nonnull Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandler == null) {
                return LazyOptional.empty();
            }
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void onOpen(World world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof TallFurniture || block instanceof BookCabinet || block instanceof BookCabinetHinge || block instanceof Cabinet || block instanceof CabinetHinge || block instanceof CupboardCounter) {
            this.playSound(world, pos, (SoundEvent)SoundsInit.CABINET_OPEN.get(), 0.5f);
        } else {
            this.playSound(world, pos, (SoundEvent)SoundsInit.DRAWER_OPEN.get(), 0.5f);
        }
    }

    protected void onClose(World world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof TallFurniture || block instanceof BookCabinet || block instanceof BookCabinetHinge || block instanceof Cabinet || block instanceof CabinetHinge || block instanceof CupboardCounter) {
            this.playSound(world, pos, (SoundEvent)SoundsInit.CABINET_CLOSE.get(), 0.5f);
        } else {
            this.playSound(world, pos, (SoundEvent)SoundsInit.DRAWER_CLOSE.get(), 0.5f);
        }
    }

    private void playSound(World world, BlockPos pos, SoundEvent sound, float volume) {
        if (world != null && !world.field_72995_K) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.5;
            double z = (double)pos.func_177952_p() + 0.5;
            world.func_184148_a(null, x, y, z, sound, SoundCategory.BLOCKS, volume, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }
}

