/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.storage;

import com.mcwfurnitures.kikoz.init.BlockEntityInit;
import com.mcwfurnitures.kikoz.init.SoundsInit;
import com.mcwfurnitures.kikoz.objects.TallFurniture;
import com.mcwfurnitures.kikoz.objects.bookshelves.BookCabinet;
import com.mcwfurnitures.kikoz.objects.bookshelves.BookCabinetHinge;
import com.mcwfurnitures.kikoz.objects.cabinets.Cabinet;
import com.mcwfurnitures.kikoz.objects.cabinets.CabinetHinge;
import com.mcwfurnitures.kikoz.objects.counters.CupboardCounter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class StorageTileEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final IItemHandler itemHandler = new InvWrapper((Container)this);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof TallFurniture || state.getBlock() instanceof BookCabinet || state.getBlock() instanceof BookCabinetHinge || state.getBlock() instanceof Cabinet || state.getBlock() instanceof CabinetHinge || state.getBlock() instanceof CupboardCounter) {
                this.playSound(null, level, pos, true, (SoundEvent)SoundsInit.CABINET_OPEN.get(), 0.5f);
            } else {
                this.playSound(null, level, pos, true, (SoundEvent)SoundsInit.DRAWER_OPEN.get(), 0.5f);
            }
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof TallFurniture || state.getBlock() instanceof BookCabinet || state.getBlock() instanceof BookCabinetHinge || state.getBlock() instanceof Cabinet || state.getBlock() instanceof CabinetHinge || state.getBlock() instanceof CupboardCounter) {
                this.playSound(null, level, pos, false, (SoundEvent)SoundsInit.CABINET_CLOSE.get(), 0.5f);
            } else {
                this.playSound(null, level, pos, false, (SoundEvent)SoundsInit.DRAWER_CLOSE.get(), 0.5f);
            }
        }

        private void playSound(@Nullable Entity entity, Level level, BlockPos pos, boolean open, SoundEvent sound, float volume) {
            level.playSound(entity, pos, sound, SoundSource.BLOCKS, volume, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int num, int num2) {
        }

        protected boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof ChestMenu) {
                Container container = ((ChestMenu)player.containerMenu).getContainer();
                return container == StorageTileEntity.this;
            }
            return false;
        }
    };
    private final IItemHandler[] sidedHandlers = new IItemHandler[]{new InvWrapper((Container)this)};

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public StorageTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityInit.FURNITURE_STORAGE.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag)) {
            ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (!this.trySaveLootTable(pTag)) {
            ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> stack) {
        this.items = stack;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"mcwfurnitures.container.threerows");
    }

    protected AbstractContainerMenu createMenu(int ints, Inventory inventory) {
        return ChestMenu.threeRows((int)ints, (Inventory)inventory, (Container)this);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void updateBlockState(BlockState state, boolean bool) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(bool)), 3);
    }

    void playSound(BlockState state, SoundEvent event) {
        Vec3i vec3i = ((Direction)state.getValue((Property)BarrelBlock.FACING)).getUnitVec3i();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound((Player)null, d0, d1, d2, event, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public IItemHandler getItemHandler(Direction side) {
        return this.sidedHandlers[side == null ? 0 : side.ordinal() % this.sidedHandlers.length];
    }

    private static IItemHandler getItemHandler(StorageTileEntity entity, Direction side) {
        return entity.itemHandler;
    }
}

