/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.client.uielements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import xyz.immortius.museumcurator.client.uielements.ScrollContainerEntry;

public class ScrollContainerWidget
extends class_362
implements class_4068,
class_364,
class_6379 {
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"widget/scroller");
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_SPACE = 2;
    private int x;
    private int y;
    private int width;
    private int height;
    private double scrollAmount;
    private final List<ScrollContainerEntry> children = new ArrayList<ScrollContainerEntry>();
    private ScrollContainerEntry hovered;
    private boolean scrolling;

    public ScrollContainerWidget(int x, int y, int width, int height, List<? extends ScrollContainerEntry> entries) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.children.addAll(entries);
    }

    public void addEntry(ScrollContainerEntry entry) {
        this.children.add(entry);
    }

    private void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
    }

    private ScrollContainerEntry getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX < (double)this.x || mouseX > (double)(this.x + this.width - 6 - 2) || mouseY < (double)this.y || mouseY > (double)(this.y + this.height)) {
            return null;
        }
        double absolutePos = mouseY + this.scrollAmount - (double)this.y;
        int totalY = 0;
        for (ScrollContainerEntry entry : this.children) {
            int entryHeight = entry.getHeight(this.width - 6 - 2);
            if ((double)totalY < absolutePos && (double)(totalY + entryHeight) >= absolutePos) {
                return entry;
            }
            totalY += entryHeight;
        }
        return null;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderList(graphics, mouseX, mouseY, delta);
        this.renderScrollbar(graphics);
    }

    public List<class_2561> getTooltip(int mouseX, int mouseY) {
        if (this.hovered != null) {
            return this.hovered.getTooltip(mouseX, mouseY);
        }
        return Collections.emptyList();
    }

    private int getMaxScroll() {
        return Math.max(0, this.getTotalListHeight() - this.height);
    }

    private int getTotalListHeight() {
        return this.children.stream().map(x -> x.getHeight(this.width)).reduce(0, Integer::sum);
    }

    protected void renderList(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_44379(this.x, this.y, this.x + this.width, this.y + this.height);
        int absoluteY = 0;
        for (ScrollContainerEntry child : this.children) {
            int rowBottom = absoluteY + child.getHeight(this.width - 6 - 2);
            if ((double)rowBottom >= this.scrollAmount && (double)absoluteY <= this.scrollAmount + (double)this.height) {
                child.render(graphics, this.y + absoluteY - (int)this.scrollAmount, this.x, this.width - 6 - 2, rowBottom - absoluteY, mouseX, mouseY, Objects.equals(this.hovered, child), delta);
            }
            absoluteY = rowBottom;
        }
        graphics.method_44380();
    }

    private void renderScrollbar(class_332 graphics) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll == 0) {
            return;
        }
        int right = this.x + this.width;
        int scrollerSize = (int)((float)(this.height * this.height) / (float)this.getTotalListHeight());
        int scrollerPos = (int)this.scrollAmount * (this.height - (scrollerSize = class_3532.method_15340((int)scrollerSize, (int)32, (int)(this.height - 8)))) / maxScroll + this.y;
        if (scrollerPos < this.y) {
            scrollerPos = this.y;
        }
        graphics.method_52706(class_1921::method_62277, SCROLLER_SPRITE, right - 6, scrollerPos, 6, scrollerSize);
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)(this.x + this.width - 6) && mouseX < (double)(this.x + this.width);
        this.method_25398(true);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        ScrollContainerEntry e = this.getEntryAtPosition(mouseX, mouseY);
        if (e != null && e.method_25402(mouseX, mouseY, button)) {
            this.method_25395(e);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.y) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.y + (double)this.height) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int j = class_3532.method_15340((int)((int)((float)(this.height * this.height) / (float)this.getTotalListHeight())), (int)32, (int)(this.height - 8));
                double d1 = Math.max(1.0, d0 / (double)(this.height - j));
                this.setScrollAmount(this.scrollAmount + deltaY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta, double wheelDelta) {
        this.setScrollAmount(this.scrollAmount - wheelDelta * 20.0);
        return true;
    }

    public boolean method_25404(int p_93434_, int p_93435_, int p_93436_) {
        if (super.method_25404(p_93434_, p_93435_, p_93436_)) {
            return true;
        }
        if (class_310.method_1551().field_1690.field_1894.method_1417(p_93434_, p_93435_)) {
            this.setScrollAmount(this.scrollAmount - 20.0);
            return true;
        }
        if (class_310.method_1551().field_1690.field_1881.method_1417(p_93434_, p_93435_)) {
            this.setScrollAmount(this.scrollAmount + 20.0);
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height) && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width);
    }

    public void method_37020(class_6382 output) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void scrollUp() {
        this.setScrollAmount(this.scrollAmount - 20.0);
    }

    public void scrollDown() {
        this.setScrollAmount(this.scrollAmount + 20.0);
    }
}

