/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.client.uielements;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import xyz.immortius.museumcurator.client.uielements.IntegerSlider;
import xyz.immortius.museumcurator.common.MuseumCuratorConstants;
import xyz.immortius.museumcurator.config.MuseumCuratorConfig;
import xyz.immortius.museumcurator.config.system.BooleanFieldMetadata;
import xyz.immortius.museumcurator.config.system.ConfigMetadata;
import xyz.immortius.museumcurator.config.system.EnumFieldMetadata;
import xyz.immortius.museumcurator.config.system.FieldMetadata;
import xyz.immortius.museumcurator.config.system.IntFieldMetadata;
import xyz.immortius.museumcurator.config.system.MetadataBuilder;
import xyz.immortius.museumcurator.config.system.SectionMetadata;
import xyz.immortius.museumcurator.config.system.StringFieldMetadata;

public class SettingListWidget
extends class_4265<SettingEntry> {
    private class_342 lastFocused = null;
    private int rowWidth;

    public SettingListWidget(class_310 minecraft, class_437 parent, int width, int top, int bottom, int rowWidth) {
        super(minecraft, width, bottom - top, top, 22);
        this.rowWidth = rowWidth;
        ConfigMetadata metadata = MetadataBuilder.build(MuseumCuratorConfig.class);
        MuseumCuratorConfig defaultConfig = new MuseumCuratorConfig();
        for (SectionMetadata section : metadata.getSections().values()) {
            Object defaultSection = section.getSectionObject(defaultConfig);
            Object configSection = section.getSectionObject(MuseumCuratorConfig.get());
            this.method_25321((class_350.class_351)new SectionTitleEntry(section.getDisplayName()));
            for (FieldMetadata field : section.getFields().values()) {
                Object defaultValue;
                if (field instanceof BooleanFieldMetadata) {
                    BooleanFieldMetadata boolField = (BooleanFieldMetadata)field;
                    defaultValue = (Boolean)boolField.getValue(defaultSection);
                    this.method_25321((class_350.class_351)new BooleanEntry(this, field.getDisplayName(), () -> (Boolean)boolField.getValue(configSection), x -> boolField.setValue(configSection, x), (Boolean)defaultValue));
                    continue;
                }
                if (field instanceof EnumFieldMetadata) {
                    EnumFieldMetadata enumField = (EnumFieldMetadata)field;
                    defaultValue = (Enum)enumField.getValue(defaultSection);
                    this.method_25321((class_350.class_351)new EnumEntry(this, enumField.getDisplayName(), enumField.enumType(), () -> (Enum)enumField.getValue(configSection), x -> enumField.setValue(configSection, x), (Enum<?>)defaultValue));
                    continue;
                }
                if (field instanceof IntFieldMetadata) {
                    IntFieldMetadata intField = (IntFieldMetadata)field;
                    defaultValue = (Integer)intField.getValue(defaultSection);
                    if (intField.getMaxValue() - intField.getMinValue() > 256) {
                        this.method_25321((class_350.class_351)new ExtendedIntegerEntry(field.getDisplayName(), intField.getMinValue(), intField.getMaxValue(), () -> (Integer)intField.getValue(configSection), x -> intField.setValue(configSection, x), (Integer)defaultValue));
                        continue;
                    }
                    this.method_25321((class_350.class_351)new IntegerEntry(this, field.getDisplayName(), intField.getMinValue(), intField.getMaxValue(), () -> (Integer)intField.getValue(configSection), x -> intField.setValue(configSection, x), (Integer)defaultValue));
                    continue;
                }
                if (field instanceof StringFieldMetadata) {
                    StringFieldMetadata stringField = (StringFieldMetadata)field;
                    this.method_25321((class_350.class_351)new StringEntry(field.getDisplayName(), () -> (String)stringField.getValue(configSection), x -> stringField.setValue(configSection, x), (String)stringField.getValue(defaultSection)));
                    continue;
                }
                MuseumCuratorConstants.LOGGER.info("Skipping config option {} as type not supported", (Object)field.getName());
            }
        }
    }

    public int method_25322() {
        return this.rowWidth;
    }

    protected int method_25329() {
        return this.field_22758 / 2 + this.method_25322() / 2 + 4;
    }

    public void tick() {
        this.method_25396().forEach(SettingEntry::tick);
    }

    public void reset() {
        this.method_25396().forEach(SettingEntry::reset);
    }

    public class SectionTitleEntry
    extends SettingEntry {
        private final class_2561 displayName;

        public SectionTitleEntry(class_2561 displayName) {
            this.displayName = displayName;
        }

        public void method_25343(class_332 graphics, int listIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            graphics.method_51439(((SettingListWidget)SettingListWidget.this).field_22740.field_1772, this.displayName, left + 12, top + 8, 0xFFFFFF, true);
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }

    public class BooleanEntry
    extends AbstractWidgetEntry<class_5676<Boolean>> {
        private final Boolean defaultValue;
        private final Consumer<Boolean> setter;

        public BooleanEntry(SettingListWidget this$0, class_2561 displayName, Supplier<Boolean> getter, Consumer<Boolean> setter, Boolean defaultValue) {
            super(this$0, (class_339)new class_5676.class_5677(x -> class_2561.method_43471((String)(x != false ? "gui.yes" : "gui.no"))).method_32624((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}).method_32619((Object)getter.get()).method_32617(0, 0, this$0.method_25322(), 20, displayName, (cycleButton, value) -> setter.accept((Boolean)value)));
            this.defaultValue = defaultValue;
            this.setter = setter;
        }

        @Override
        public void reset() {
            this.setter.accept(this.defaultValue);
            ((class_5676)this.widget).method_32605((Object)this.defaultValue);
        }
    }

    public class EnumEntry
    extends AbstractWidgetEntry<class_5676<Enum<?>>> {
        private final Enum<?> defaultValue;
        private final Consumer<Enum<?>> setter;

        public EnumEntry(SettingListWidget this$0, class_2561 displayName, Class<? extends Enum<?>> type, Supplier<Enum<?>> getter, Consumer<Enum<?>> setter, Enum<?> defaultValue) {
            super(this$0, (class_339)new class_5676.class_5677(x -> class_2561.method_43471((String)("enumvalue.museumcurator." + type.getSimpleName() + "." + x.name()))).method_32624((Object[])type.getEnumConstants()).method_32619(getter.get()).method_32617(0, 0, this$0.method_25322(), 20, displayName, (cycleButton, value) -> setter.accept((Enum<?>)value)));
            this.defaultValue = defaultValue;
            this.setter = setter;
        }

        @Override
        public void reset() {
            this.setter.accept(this.defaultValue);
            ((class_5676)this.widget).method_32605(this.defaultValue);
        }
    }

    public class ExtendedIntegerEntry
    extends AbstractWidgetEntry<class_342> {
        private final class_2561 displayName;
        private final Integer defaultValue;
        private final Consumer<Integer> setter;

        public ExtendedIntegerEntry(class_2561 displayName, int min, int max, Supplier<Integer> getter, Consumer<Integer> setter, Integer defaultValue) {
            super(SettingListWidget.this, (class_339)new class_342(((SettingListWidget)SettingListWidget.this).field_22740.field_1772, 0, 0, SettingListWidget.this.method_25322(), 20, displayName));
            this.displayName = displayName;
            this.defaultValue = defaultValue;
            this.setter = setter;
            ((class_342)this.widget).method_1890(x -> {
                if (x.isEmpty() || "-".equals(x)) {
                    return true;
                }
                try {
                    int val = Integer.parseInt(x);
                    return val >= min && val <= max;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            ((class_342)this.widget).method_1852(getter.get().toString());
            ((class_342)this.widget).method_1888(true);
            ((class_342)this.widget).method_1863(value -> {
                if (value.isEmpty() || "-".equals(value)) {
                    if (0 >= min && 0 <= max) {
                        setter.accept(0);
                    }
                } else {
                    setter.accept(Integer.parseInt(value));
                }
            });
        }

        @Override
        public void reset() {
            this.setter.accept(this.defaultValue);
            ((class_342)this.widget).method_1852(this.defaultValue.toString());
        }

        @Override
        public boolean method_25402(double x, double y, int mouseButton) {
            if (super.method_25402(x, y, mouseButton)) {
                SettingListWidget.this.lastFocused = (class_342)this.widget;
                ((class_342)this.widget).method_25365(true);
                return true;
            }
            return false;
        }

        @Override
        public void method_25343(class_332 graphics, int listIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            int labelLength = ((SettingListWidget)SettingListWidget.this).field_22740.field_1772.method_27525((class_5348)this.displayName);
            graphics.method_27535(((SettingListWidget)SettingListWidget.this).field_22740.field_1772, this.displayName, left, top + 6, 0xFFFFFF);
            ((class_342)this.widget).method_46421(left + labelLength + 6);
            ((class_342)this.widget).method_25358(SettingListWidget.this.method_25322() - labelLength - 6);
            ((class_342)this.widget).method_46419(top);
            ((class_342)this.widget).method_25394(graphics, mouseX, mouseY, delta);
        }

        public boolean method_25400(char p_94683_, int p_94684_) {
            return ((class_342)this.widget).method_25400(p_94683_, p_94684_);
        }
    }

    public class IntegerEntry
    extends AbstractWidgetEntry<IntegerSlider> {
        private final Integer defaultValue;
        private final Consumer<Integer> setter;

        public IntegerEntry(SettingListWidget this$0, class_2561 displayName, int min, int max, Supplier<Integer> getter, Consumer<Integer> setter, Integer defaultValue) {
            super(this$0, (class_339)new IntegerSlider(0, 0, this$0.method_25322(), 20, displayName, min, max, getter, setter));
            this.setter = setter;
            this.defaultValue = defaultValue;
        }

        @Override
        public void reset() {
            this.setter.accept(this.defaultValue);
            ((IntegerSlider)this.widget).setValue(this.defaultValue);
        }
    }

    public class StringEntry
    extends AbstractWidgetEntry<class_342> {
        private final class_2561 displayName;
        private final String defaultValue;
        private final Consumer<String> setter;

        public StringEntry(class_2561 displayName, Supplier<String> getter, Consumer<String> setter, String defaultValue) {
            super(SettingListWidget.this, (class_339)new class_342(((SettingListWidget)SettingListWidget.this).field_22740.field_1772, 0, 0, SettingListWidget.this.method_25322(), 20, displayName));
            this.displayName = displayName;
            this.defaultValue = defaultValue;
            this.setter = setter;
            ((class_342)this.widget).method_1852(getter.get());
            ((class_342)this.widget).method_1888(true);
            ((class_342)this.widget).method_1863(setter);
        }

        @Override
        public void reset() {
            this.setter.accept(this.defaultValue);
            ((class_342)this.widget).method_1852(this.defaultValue);
        }

        @Override
        public boolean method_25402(double x, double y, int mouseButton) {
            if (super.method_25402(x, y, mouseButton)) {
                SettingListWidget.this.lastFocused = (class_342)this.widget;
                ((class_342)this.widget).method_25365(true);
                return true;
            }
            return false;
        }

        @Override
        public void method_25343(class_332 graphics, int listIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            int labelLength = ((SettingListWidget)SettingListWidget.this).field_22740.field_1772.method_27525((class_5348)this.displayName);
            graphics.method_27535(((SettingListWidget)SettingListWidget.this).field_22740.field_1772, this.displayName, left, top + 6, 0xFFFFFF);
            ((class_342)this.widget).method_46421(left + labelLength + 6);
            ((class_342)this.widget).method_25358(SettingListWidget.this.method_25322() - labelLength - 6);
            ((class_342)this.widget).method_46419(top);
            ((class_342)this.widget).method_25394(graphics, mouseX, mouseY, delta);
        }

        public boolean method_25400(char p_94683_, int p_94684_) {
            return ((class_342)this.widget).method_25400(p_94683_, p_94684_);
        }
    }

    public static abstract class SettingEntry
    extends class_4265.class_4266<SettingEntry> {
        public void tick() {
        }

        public void reset() {
        }
    }

    public static abstract class AbstractWidgetEntry<T extends class_339>
    extends SettingEntry {
        protected final T widget;
        private boolean dragging;
        final /* synthetic */ SettingListWidget this$0;

        public AbstractWidgetEntry(T widget) {
            this.this$0 = this$0;
            this.widget = widget;
        }

        public void method_25343(class_332 graphics, int listIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            this.widget.method_46421(left);
            this.widget.method_46419(top);
            this.widget.method_25394(graphics, mouseX, mouseY, delta);
        }

        public boolean method_25402(double x, double y, int mouseButton) {
            if (this.this$0.lastFocused != null && this.this$0.lastFocused != this.widget) {
                this.this$0.lastFocused.method_25365(false);
            }
            this.dragging = true;
            return this.widget.method_25402(x, y, mouseButton);
        }

        public boolean method_25406(double x, double y, int mouseButton) {
            this.dragging = false;
            return this.widget.method_25406(x, y, mouseButton);
        }

        public boolean method_25403(double x, double y, int mouseButton, double deltaX, double deltaY) {
            if (this.dragging) {
                return this.widget.method_25403(x, y, mouseButton, deltaX, deltaY);
            }
            return false;
        }

        public boolean method_25405(double p_93537_, double p_93538_) {
            return this.widget.method_25405(p_93537_, p_93538_);
        }

        public boolean method_25404(int p_94710_, int p_94711_, int p_94712_) {
            return this.widget.method_25404(p_94710_, p_94711_, p_94712_);
        }

        public boolean method_16803(int p_94715_, int p_94716_, int p_94717_) {
            return this.widget.method_16803(p_94715_, p_94716_, p_94717_);
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.widget);
        }
    }
}

