/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5627;
import net.minecraft.class_9331;
import xyz.immortius.museumcurator.common.data.CollectionItem;
import xyz.immortius.museumcurator.common.data.MuseumCollection;
import xyz.immortius.museumcurator.common.data.MuseumExhibit;

public final class MuseumCollections {
    private static final Set<String> IGNORE_TAGS = ImmutableSet.of((Object)"Damage");
    private static List<MuseumCollection> collections = Collections.emptyList();
    private static ListMultimap<class_1792, CollectionItem> collectionItems = ImmutableListMultimap.of();
    private static final Set<CollectionItem> checkedItems = new LinkedHashSet<CollectionItem>();

    private MuseumCollections() {
    }

    public static List<MuseumCollection> getCollections() {
        return collections;
    }

    public static void setCollections(Collection<MuseumCollection> newCollections) {
        collections = ImmutableList.copyOf(newCollections);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (MuseumCollection collection : newCollections) {
            for (MuseumExhibit exhibit : collection.getExhibits()) {
                for (CollectionItem item : exhibit.getItems()) {
                    builder.put((Object)item.itemStack().method_7909(), (Object)item);
                }
            }
        }
        collectionItems = builder.build();
    }

    public static boolean isValidCollectionItem(class_1799 queryItem) {
        return MuseumCollections.getCollectionItemStack(queryItem) != null;
    }

    public static CollectionItem getCollectionItemStack(class_1799 itemStack) {
        List candidates = collectionItems.get((Object)itemStack.method_7909());
        CollectionItem bestMatch = null;
        int bestExcessTags = 0;
        for (CollectionItem candidate : candidates) {
            boolean match = true;
            if (!candidate.componentFilter().method_57848()) {
                for (Map.Entry entry : candidate.componentFilter().method_57846()) {
                    if (!((Optional)entry.getValue()).isPresent()) continue;
                    Object data = ((Optional)entry.getValue()).get();
                    match = itemStack.method_57353().method_57829((class_9331)entry.getKey()) != null && data.equals(itemStack.method_57353().method_57829((class_9331)entry.getKey()));
                }
            }
            if (!match) continue;
            int excessTags = itemStack.method_57353().method_57835() - candidate.itemStack().method_57353().method_57835();
            if (bestMatch != null && excessTags >= bestExcessTags) continue;
            bestMatch = candidate;
            bestExcessTags = excessTags;
        }
        return bestMatch;
    }

    public static void setCheckedItems(Collection<class_1799> items) {
        checkedItems.clear();
        MuseumCollections.checkItems(items);
    }

    public static void checkItems(Collection<class_1799> items) {
        for (class_1799 item : items) {
            CollectionItem collectionItem = MuseumCollections.getCollectionItemStack(item);
            if (collectionItem == null) continue;
            checkedItems.add(collectionItem);
        }
    }

    public static void uncheckItems(Collection<class_1799> items) {
        for (class_1799 item : items) {
            CollectionItem collectionItem = MuseumCollections.getCollectionItemStack(item);
            if (collectionItem == null) continue;
            checkedItems.remove(collectionItem);
        }
    }

    public static void clearCheckedItems() {
        checkedItems.clear();
    }

    public static boolean isChecked(CollectionItem item) {
        return item != null && checkedItems.contains(item);
    }

    public static long countChecked(List<CollectionItem> items) {
        return items.stream().filter(MuseumCollections::isChecked).count();
    }

    public static Set<class_1792> getAllCollectionItems() {
        return collectionItems.keySet();
    }

    public static class ComparingTagVisitor
    implements class_5627 {
        private final class_2520 target;
        private boolean match = false;

        ComparingTagVisitor(class_2520 t) {
            this.target = t;
        }

        public boolean isMatch(class_2520 tag) {
            this.match = false;
            tag.method_32289((class_5627)this);
            return this.match;
        }

        public void method_32302(class_2519 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2519) {
                class_2519 t = (class_2519)class_25202;
                this.match = t.method_10714().equals(tag.method_10714());
            }
        }

        public void method_32291(class_2481 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2514) {
                class_2514 t = (class_2514)class_25202;
                this.match = t.method_10699() == tag.method_10699();
            }
        }

        public void method_32301(class_2516 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2514) {
                class_2514 t = (class_2514)class_25202;
                this.match = t.method_10699() == tag.method_10699();
            }
        }

        public void method_32297(class_2497 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2514) {
                class_2514 t = (class_2514)class_25202;
                this.match = t.method_10699() == tag.method_10699();
            }
        }

        public void method_32300(class_2503 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2514) {
                class_2514 t = (class_2514)class_25202;
                this.match = t.method_10699() == tag.method_10699();
            }
        }

        public void method_32295(class_2494 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2514) {
                class_2514 t = (class_2514)class_25202;
                this.match = t.method_10697() - tag.method_10697() < (double)1.0E-5f;
            }
        }

        public void method_32293(class_2489 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2514) {
                class_2514 t = (class_2514)class_25202;
                this.match = Math.abs(t.method_10697() - tag.method_10697()) < (double)1.0E-5f;
            }
        }

        public void method_32290(class_2479 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2479) {
                class_2479 t = (class_2479)class_25202;
                t.equals((Object)tag);
            }
        }

        public void method_32296(class_2495 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2495) {
                class_2495 t = (class_2495)class_25202;
                t.equals((Object)tag);
            }
        }

        public void method_32299(class_2501 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2501) {
                class_2501 t = (class_2501)class_25202;
                t.equals((Object)tag);
            }
        }

        public void method_32298(class_2499 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2499) {
                class_2499 t = (class_2499)class_25202;
                for (class_2520 targetValue : t) {
                    ComparingTagVisitor childVisitor = new ComparingTagVisitor(targetValue);
                    boolean foundMatch = false;
                    for (class_2520 actualValue : tag) {
                        if (!childVisitor.isMatch(actualValue)) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    return;
                }
                this.match = true;
            }
        }

        public void method_32292(class_2487 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2487) {
                class_2487 t = (class_2487)class_25202;
                for (String key : t.method_10541()) {
                    if (IGNORE_TAGS.contains(key) || tag.method_10580(key) != null && new ComparingTagVisitor(t.method_10580(key)).isMatch(tag.method_10580(key))) continue;
                    return;
                }
                this.match = true;
            }
        }

        public void method_32294(class_2491 tag) {
            class_2520 class_25202 = this.target;
            if (class_25202 instanceof class_2491) {
                class_2491 t = (class_2491)class_25202;
                this.match = t.equals(tag);
            }
        }
    }
}

