/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.common.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import xyz.immortius.museumcurator.common.data.CollectionItem;

public class RawExhibit {
    private final String collection;
    private final String name;
    private String relativeTo;
    private Placement placement;
    private final List<CollectionItem> items;
    private List<ItemGroup> insertGroups;
    public static final Codec<ItemGroup> ITEM_GROUP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CollectionItem.CODEC.optionalFieldOf("relativeTo", null).forGetter(x -> x.relativeTo), (App)Codec.STRING.optionalFieldOf("placement", (Object)Placement.After.getId()).forGetter(x -> x.placement() != null ? x.placement().getId() : ""), (App)CollectionItem.CODEC.listOf().fieldOf("items").forGetter(x -> x.items)).apply((Applicative)instance, (relativeTo, positioning, items) -> new ItemGroup((CollectionItem)relativeTo, Placement.parse(positioning), (List<CollectionItem>)items)));
    public static final Codec<RawExhibit> EXHIBIT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("collection").forGetter(x -> x.collection), (App)Codec.STRING.fieldOf("name").forGetter(x -> x.name), (App)Codec.STRING.optionalFieldOf("relativeTo", (Object)"").forGetter(x -> x.relativeTo), (App)Codec.STRING.optionalFieldOf("placement", (Object)Placement.After.getId()).forGetter(x -> x.placement != null ? x.placement.getId() : ""), (App)CollectionItem.CODEC.listOf().fieldOf("items").forGetter(x -> x.items), (App)ITEM_GROUP_CODEC.listOf().optionalFieldOf("insertGroups", Collections.emptyList()).forGetter(x -> x.insertGroups)).apply((Applicative)instance, (collection, name, relativeTo, positioning, items, insertGroups) -> new RawExhibit((String)collection, (String)name, (String)relativeTo, Placement.parse(positioning), (List<CollectionItem>)items, (List<ItemGroup>)insertGroups)));

    public RawExhibit(String collection, String name, String relativeTo, Placement placement, List<CollectionItem> items, List<ItemGroup> itemGroups) {
        this.collection = collection;
        this.name = name;
        this.relativeTo = relativeTo;
        this.placement = placement;
        this.items = new ArrayList<CollectionItem>(items);
        this.insertGroups = new ArrayList<ItemGroup>(itemGroups);
    }

    public String getCollection() {
        return this.collection;
    }

    public String getName() {
        return this.name;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public List<CollectionItem> getItems() {
        return this.items;
    }

    public List<ItemGroup> getInsertGroups() {
        return this.insertGroups;
    }

    public void applyInserts() {
        boolean ignoreConstraints = false;
        while (!this.insertGroups.isEmpty()) {
            ArrayList<ItemGroup> residual = new ArrayList<ItemGroup>();
            for (ItemGroup group : this.insertGroups) {
                if (ignoreConstraints || group.relativeTo == null) {
                    this.items.addAll(group.items);
                    continue;
                }
                OptionalInt match = IntStream.range(0, this.items.size()).filter(i -> this.matchItems(group.relativeTo, this.items.get(i))).findFirst();
                if (match.isPresent()) {
                    this.items.addAll(match.getAsInt() + group.placement().shift(), group.items);
                    continue;
                }
                residual.add(group);
            }
            if (residual.size() == this.insertGroups.size()) {
                ignoreConstraints = true;
                continue;
            }
            this.insertGroups = residual;
        }
    }

    private boolean matchItems(CollectionItem a, CollectionItem b) {
        if (!class_1799.method_7984((class_1799)a.itemStack(), (class_1799)b.itemStack())) {
            return false;
        }
        return a.componentFilter().equals((Object)b.componentFilter());
    }

    public void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public static enum Placement {
        Before("before", 0),
        After("after", 1);

        private static final Map<String, Placement> lookup;
        private final String id;
        private final int shift;

        private Placement(String id, int indexShift) {
            this.id = id;
            this.shift = indexShift;
        }

        public int shift() {
            return this.shift;
        }

        public static Placement parse(String value) {
            Placement placement = lookup.get(value.toLowerCase(Locale.ROOT));
            if (placement == null) {
                placement = After;
            }
            return placement;
        }

        public String getId() {
            return this.id;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Placement pos : Placement.values()) {
                builder.put((Object)pos.getId(), (Object)pos);
            }
            lookup = builder.build();
        }
    }

    public record ItemGroup(CollectionItem relativeTo, Placement placement, List<CollectionItem> items) {
    }
}

