/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.config.system;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.museumcurator.config.system.ConfigException;
import xyz.immortius.museumcurator.config.system.FieldMetadata;

public class StringFieldMetadata
extends FieldMetadata<String> {
    public static final Logger LOGGER = LogManager.getLogger((String)"museumcurator");
    private final Field field;

    public StringFieldMetadata(Field field, String name, String comment) {
        super(field, name, comment);
        Preconditions.checkArgument((boolean)String.class.equals(field.getType()));
        this.field = field;
        this.field.setAccessible(true);
    }

    @Override
    public String serializeValue(Object object) {
        try {
            return this.field.get(object).toString();
        }
        catch (IllegalAccessException e) {
            throw new ConfigException("Failed to retrieve " + this.getName() + " from object " + String.valueOf(object), e);
        }
    }

    @Override
    public void deserializeValue(Object object, String value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set " + this.getName() + " to value " + value, e);
        }
    }
}

