/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.fabric;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Paths;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.immortius.museumcurator.common.MuseumCuratorConstants;
import xyz.immortius.museumcurator.common.data.MuseumCollections;
import xyz.immortius.museumcurator.common.items.MuseumChecklist;
import xyz.immortius.museumcurator.common.menus.MuseumChecklistMenu;
import xyz.immortius.museumcurator.common.network.ChecklistChangeRequest;
import xyz.immortius.museumcurator.common.network.ChecklistUpdateMessage;
import xyz.immortius.museumcurator.common.network.LogOnMessage;
import xyz.immortius.museumcurator.config.MuseumCuratorConfig;
import xyz.immortius.museumcurator.config.system.ConfigSystem;
import xyz.immortius.museumcurator.fabric.extensions.ResourceManagerWithRegistryAccess;
import xyz.immortius.museumcurator.server.ChecklistState;
import xyz.immortius.museumcurator.server.ServerEventHandler;
import xyz.immortius.museumcurator.server.commands.ChecklistCommands;
import xyz.immortius.museumcurator.server.commands.ItemDumpCommand;
import xyz.immortius.museumcurator.server.network.ServerChecklistUpdateReceiver;

public class MuseumCuratorMod
implements ModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"museumcurator");
    public static class_1792 MUSEUM_CHECKLIST;
    public static class_3414 WRITING_SOUND;
    public static class_3917<MuseumChecklistMenu> MUSEUM_CHECKLIST_MENU;

    public void onInitialize() {
        LOGGER.info("Initializing");
        ServerLifecycleEvents.SERVER_STARTED.register(ServerEventHandler::onServerStarted);
        ServerLifecycleEvents.SERVER_STARTING.register(ServerEventHandler::onServerStarting);
        PayloadTypeRegistry.playS2C().register(LogOnMessage.ID, LogOnMessage.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ChecklistUpdateMessage.ID, ChecklistUpdateMessage.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(ChecklistChangeRequest.ID, ChecklistChangeRequest.STREAM_CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            LogOnMessage message = new LogOnMessage(MuseumCollections.getCollections(), ChecklistState.get(server, handler.method_32311()).getCheckedItems());
            ServerPlayNetworking.send((class_3222)handler.method_32311(), (class_8710)message);
        });
        ServerPlayNetworking.registerGlobalReceiver(ChecklistChangeRequest.ID, (payload, context) -> ServerChecklistUpdateReceiver.receive(context.player().method_5682(), context.player(), payload));
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> {
            ItemDumpCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ChecklistCommands.register((CommandDispatcher<class_2168>)dispatcher, context);
        });
        MUSEUM_CHECKLIST = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.createId("museumchecklist"), (Object)((Object)new MuseumChecklist(new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)this.createId("museumchecklist"))))));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> content.addAfter((class_1935)class_1802.field_23984, new class_1935[]{MUSEUM_CHECKLIST}));
        MUSEUM_CHECKLIST_MENU = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)this.createId("museumchecklistmenu"), (Object)new class_3917(MuseumChecklistMenu::new, class_7701.field_40182));
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)MuseumCuratorConstants.WRITING_SOUND_ID, (Object)WRITING_SOUND);
        this.setupConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"museumcurator", (String)"server_data");
            }

            public void method_14491(class_3300 resourceManager) {
                ServerEventHandler.onResourceManagerReload(resourceManager, ((ResourceManagerWithRegistryAccess)resourceManager).museumcurator$getRegistryAccess());
            }
        });
    }

    private void setupConfig() {
        new ConfigSystem().synchConfig(Paths.get("defaultconfigs", "museumcurator.toml"), MuseumCuratorConfig.get());
    }

    private class_2960 createId(String id) {
        class_2960 loc = class_2960.method_60655((String)"museumcurator", (String)id);
        MuseumCuratorConstants.LOGGER.info("Creating {}", (Object)loc);
        return loc;
    }

    static {
        WRITING_SOUND = class_3414.method_47908((class_2960)MuseumCuratorConstants.WRITING_SOUND_ID);
    }
}

