/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.server;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xyz.immortius.museumcurator.common.data.CollectionItem;
import xyz.immortius.museumcurator.common.data.MuseumCollections;
import xyz.immortius.museumcurator.common.network.ChecklistUpdateMessage;
import xyz.immortius.museumcurator.config.MuseumCuratorConfig;
import xyz.immortius.museumcurator.interop.Services;

public class ChecklistState
extends class_18 {
    private final MinecraftServer server;
    private final UUID ownerId;
    private final Set<class_1799> checkedItems = new LinkedHashSet<class_1799>();

    public static ChecklistState get(MinecraftServer server, class_3222 player) {
        if (MuseumCuratorConfig.get().gameplayConfig.isIndividualChecklists(MuseumCuratorConfig.get())) {
            String checklistId = Services.GROUP_HELPER.getLeaderId(player);
            return (ChecklistState)server.method_3847(class_1937.field_25179).method_14178().method_17981().method_17924(new class_18.class_8645(() -> new ChecklistState(server, checklistId), (tag, provider) -> ChecklistState.load(server, provider, tag, checklistId), class_4284.field_19212), "museumchecklist-" + checklistId);
        }
        return (ChecklistState)server.method_3847(class_1937.field_25179).method_14178().method_17981().method_17924(new class_18.class_8645(() -> new ChecklistState(server, ""), (tag, provider) -> ChecklistState.load(server, provider, tag, ""), class_4284.field_19212), "museumchecklist");
    }

    private static ChecklistState load(MinecraftServer server, class_7225.class_7874 provider, class_2487 tag, String ownerId) {
        class_2499 items = tag.method_10554("items", 10);
        LinkedHashSet<class_1799> checkedItems = new LinkedHashSet<class_1799>();
        for (int i = 0; i < items.size(); ++i) {
            CollectionItem item = MuseumCollections.getCollectionItemStack(class_1799.method_57359((class_7225.class_7874)provider, (class_2487)items.method_10602(i)));
            if (item == null) continue;
            checkedItems.add(item.itemStack());
        }
        return new ChecklistState(server, ownerId, checkedItems);
    }

    public ChecklistState(MinecraftServer server, String ownerId) {
        this.server = server;
        this.ownerId = Strings.isNullOrEmpty((String)ownerId) ? null : UUID.fromString(ownerId);
    }

    private ChecklistState(MinecraftServer server, String ownerId, Collection<class_1799> items) {
        this(server, ownerId);
        this.checkedItems.addAll(items);
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 parent, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        class_2499 listTag = new class_2499();
        for (class_1799 item : this.checkedItems) {
            listTag.add((Object)item.method_57358(provider));
        }
        parent.method_10566("items", (class_2520)listTag);
        if (this.ownerId != null) {
            parent.method_10582("owner", this.ownerId.toString());
        }
        return parent;
    }

    public synchronized boolean check(Collection<class_1799> items) {
        List<class_1799> toAdd = items.stream().map(MuseumCollections::getCollectionItemStack).filter(Objects::nonNull).map(CollectionItem::itemStack).filter(x -> !this.checkedItems.contains(x)).toList();
        if (!toAdd.isEmpty()) {
            this.checkedItems.addAll(toAdd);
            ChecklistUpdateMessage msg = ChecklistUpdateMessage.check(toAdd);
            if (MuseumCuratorConfig.get().gameplayConfig.isIndividualChecklists(MuseumCuratorConfig.get())) {
                for (class_3222 class_32222 : Services.GROUP_HELPER.getGroupPlayers(this.server, this.ownerId)) {
                    Services.PLATFORM.sendChecklistUpdate(this.server, class_32222, msg);
                }
            } else {
                Services.PLATFORM.broadcastChecklistUpdate(this.server, msg);
            }
            this.method_80();
            return true;
        }
        return false;
    }

    public synchronized boolean uncheck(Collection<class_1799> items) {
        Set<class_1799> toRemove = items.stream().map(MuseumCollections::getCollectionItemStack).filter(Objects::nonNull).map(CollectionItem::itemStack).filter(this.checkedItems::contains).collect(Collectors.toSet());
        if (!toRemove.isEmpty()) {
            this.checkedItems.removeAll(toRemove);
            ChecklistUpdateMessage msg = ChecklistUpdateMessage.uncheck(toRemove);
            if (MuseumCuratorConfig.get().gameplayConfig.isIndividualChecklists(MuseumCuratorConfig.get())) {
                for (class_3222 class_32222 : Services.GROUP_HELPER.getGroupPlayers(this.server, this.ownerId)) {
                    Services.PLATFORM.sendChecklistUpdate(this.server, class_32222, msg);
                }
            } else {
                Services.PLATFORM.broadcastChecklistUpdate(this.server, msg);
            }
            this.method_80();
            return true;
        }
        return false;
    }

    public synchronized void uncheckAll() {
        if (!this.checkedItems.isEmpty()) {
            this.checkedItems.clear();
            ChecklistUpdateMessage msg = ChecklistUpdateMessage.uncheckAll();
            if (MuseumCuratorConfig.get().gameplayConfig.isIndividualChecklists(MuseumCuratorConfig.get())) {
                for (class_3222 class_32222 : Services.GROUP_HELPER.getGroupPlayers(this.server, this.ownerId)) {
                    Services.PLATFORM.sendChecklistUpdate(this.server, class_32222, msg);
                }
            } else {
                Services.PLATFORM.broadcastChecklistUpdate(this.server, msg);
            }
            this.method_80();
        }
    }

    public synchronized Set<class_1799> getCheckedItems() {
        return new LinkedHashSet<class_1799>(this.checkedItems);
    }
}

