/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.server;

import com.google.common.collect.HashBasedTable;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import joptsimple.internal.Strings;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xyz.immortius.museumcurator.common.MuseumCuratorConstants;
import xyz.immortius.museumcurator.common.data.MuseumCollection;
import xyz.immortius.museumcurator.common.data.MuseumCollections;
import xyz.immortius.museumcurator.common.data.MuseumExhibit;
import xyz.immortius.museumcurator.common.data.RawExhibit;
import xyz.immortius.museumcurator.config.MuseumCuratorConfig;
import xyz.immortius.museumcurator.config.system.ConfigSystem;

public final class ServerEventHandler {
    private static final String SERVERCONFIG = "serverconfig";
    private static final ConfigSystem configSystem = new ConfigSystem();

    private ServerEventHandler() {
    }

    public static void onServerStarting(MinecraftServer server) {
        configSystem.synchConfig(server.method_27050(class_5218.field_24188).resolve(SERVERCONFIG).resolve("museumcurator.toml"), MuseumCuratorConfig.get());
    }

    public static void onServerStarted(MinecraftServer server) {
    }

    public static void onResourceManagerReload(class_3300 resourceManager, class_5455 registryAccess) {
        List<RawExhibit> rawExhibits = new ArrayList<RawExhibit>();
        for (Map.Entry entry : resourceManager.method_14488("museumexhibits", r -> true).entrySet()) {
            try (InputStreamReader reader = new InputStreamReader(((class_3298)entry.getValue()).method_14482());){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                RawExhibit exhibit = (RawExhibit)RawExhibit.EXHIBIT_CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess), (Object)jsonElement).getOrThrow();
                rawExhibits.add(exhibit);
            }
            catch (IOException | RuntimeException e) {
                MuseumCuratorConstants.LOGGER.error("Failed to read museum exhibit data '{}'", entry.getKey(), (Object)e);
            }
        }
        rawExhibits = ServerEventHandler.prepareExhibits(rawExhibits);
        Collection<MuseumCollection> collections = ServerEventHandler.prepareCollections(rawExhibits);
        MuseumCollections.setCollections(collections);
        MuseumCuratorConstants.LOGGER.info("Loaded {} museum exhibits", (Object)rawExhibits.size());
    }

    @NotNull
    private static Collection<MuseumCollection> prepareCollections(List<RawExhibit> rawExhibits) {
        boolean ignoreConstraints = false;
        LinkedHashMap<String, MuseumCollection> collectionsLookup = new LinkedHashMap<String, MuseumCollection>();
        while (!rawExhibits.isEmpty()) {
            ArrayList<RawExhibit> residual = new ArrayList<RawExhibit>();
            for (RawExhibit exhibit : rawExhibits) {
                MuseumCollection collection = collectionsLookup.computeIfAbsent(exhibit.getCollection(), s -> new MuseumCollection((String)s, Collections.emptyList()));
                if (ignoreConstraints || Strings.isNullOrEmpty((String)exhibit.getRelativeTo())) {
                    collection.getExhibits().add(new MuseumExhibit(exhibit.getName(), exhibit.getItems()));
                    continue;
                }
                OptionalInt match = IntStream.range(0, collection.getExhibits().size()).filter(i -> collection.getExhibits().get(i).getRawName().equals(exhibit.getRelativeTo())).findFirst();
                if (match.isPresent()) {
                    collection.getExhibits().add(match.getAsInt() + exhibit.getPlacement().shift(), new MuseumExhibit(exhibit.getName(), exhibit.getItems()));
                    continue;
                }
                residual.add(exhibit);
            }
            if (residual.size() == rawExhibits.size()) {
                ignoreConstraints = true;
                continue;
            }
            rawExhibits = residual;
        }
        return collectionsLookup.values();
    }

    private static List<RawExhibit> prepareExhibits(List<RawExhibit> rawExhibits) {
        HashBasedTable exhibitTable = HashBasedTable.create();
        for (RawExhibit exhibit : rawExhibits) {
            RawExhibit existingExhibit = (RawExhibit)exhibitTable.get((Object)exhibit.getCollection(), (Object)exhibit.getName());
            if (existingExhibit != null) {
                existingExhibit.getInsertGroups().addAll(exhibit.getInsertGroups());
                existingExhibit.getItems().addAll(exhibit.getItems());
                if (!Strings.isNullOrEmpty((String)existingExhibit.getRelativeTo())) continue;
                existingExhibit.setRelativeTo(exhibit.getRelativeTo());
                existingExhibit.setPlacement(exhibit.getPlacement());
                continue;
            }
            exhibitTable.put((Object)exhibit.getCollection(), (Object)exhibit.getName(), (Object)exhibit);
        }
        exhibitTable.values().forEach(RawExhibit::applyInserts);
        return new ArrayList<RawExhibit>(exhibitTable.values());
    }
}

