/*
 * Decompiled with CFR 0.152.
 */
package xyz.immortius.museumcurator.server.commands;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import xyz.immortius.museumcurator.common.data.MuseumCollections;

public class ItemDumpCommand {
    private static final SimpleCommandExceptionType FAILED_TO_DUMP = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.museumcurator.dumperror"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"museumcommand:itemDump").requires(x -> x.method_9259(2))).executes(ItemDumpCommand::itemDump));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"museumcommand:nonCollectionItemDump").requires(x -> x.method_9259(2))).executes(ItemDumpCommand::nonCollectionItemDump));
    }

    private static int nonCollectionItemDump(CommandContext<class_2168> cmd) throws CommandSyntaxException {
        class_2378 registry = ((class_2168)cmd.getSource()).method_9211().method_30611().method_30530(class_7924.field_41197);
        Set collectionItems = MuseumCollections.getAllCollectionItems().stream().map(arg_0 -> ((class_2378)registry).method_10221(arg_0)).collect(Collectors.toSet());
        Sets.SetView missingItems = Sets.difference((Set)registry.method_10235(), collectionItems);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("missingitems.json", new String[0]), new OpenOption[0]);){
            Gson gson = new Gson();
            gson.toJson(missingItems.stream().map(class_2960::toString).toList(), (Appendable)writer);
        }
        catch (IOException e) {
            throw FAILED_TO_DUMP.create();
        }
        return 0;
    }

    private static int itemDump(CommandContext<class_2168> cmd) throws CommandSyntaxException {
        class_2378 registry = ((class_2168)cmd.getSource()).method_9211().method_30611().method_30530(class_7924.field_41197);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("items.json", new String[0]), new OpenOption[0]);){
            Gson gson = new Gson();
            gson.toJson(registry.method_10235().stream().map(class_2960::toString).toList(), (Appendable)writer);
        }
        catch (IOException e) {
            throw FAILED_TO_DUMP.create();
        }
        return 0;
    }
}

