/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.common;

import com.mojang.serialization.Codec;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public record Version(int major, int minor, int patch) {
    public static final Version INVALID = new Version(-1, -1, -1);
    public static final Codec<Version> CODEC = Codec.STRING.xmap(Version::of, Version::toString);
    public static final Version SERVER_CONFIG_VERSION = Version.of("1.0.0");
    public static final Version CLIENT_CONFIG_VERSION = Version.of("1.0.1");
    public static final Version RESOURCE_PACKS_MIN_SUPPORT_VERSION = Version.of("1.0.0");
    public static final Version CURRENT_MOD_VERSION = Version.of("1.2.3+1.19.1".substring(0, "1.2.3+1.19.1".indexOf(43)));
    public static final Version PACKET_V1_VERSION = Version.of("1.0.0");
    public static final Version PACKET_V2_VERSION = Version.of("1.2.0");

    public static Version readVersion(class_2540 buf) {
        try {
            short major = buf.readUnsignedByte();
            short minor = buf.readUnsignedByte();
            short patch = buf.readUnsignedByte();
            return new Version(major, minor, patch);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse version:", e);
        }
    }

    public static Version of(@NotNull String version) {
        int patch;
        int minor;
        int major;
        String[] numbers = version.split("\\.");
        try {
            major = Integer.parseInt(numbers[0]);
            minor = Integer.parseInt(numbers[1]);
            patch = Integer.parseInt(numbers[2]);
        }
        catch (Exception ignored) {
            return INVALID;
        }
        return new Version(major, minor, patch);
    }

    public boolean isLessThan(Version version) {
        if (this.major != version.major) {
            return this.major < version.major;
        }
        if (this.minor != version.minor) {
            return this.minor < version.minor;
        }
        if (this.patch != version.patch) {
            return this.patch < version.patch;
        }
        return false;
    }

    public boolean isMoreThan(Version version) {
        if (this.major != version.major) {
            return this.major > version.major;
        }
        if (this.minor != version.minor) {
            return this.minor > version.minor;
        }
        if (this.patch != version.patch) {
            return this.patch > version.patch;
        }
        return false;
    }

    public boolean isGreaterOrEqualThan(Version version) {
        return !this.isLessThan(version);
    }

    public boolean isLesserOrEqualThan(Version version) {
        return !this.isMoreThan(version);
    }

    public boolean is(Version version) {
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch;
    }

    @Override
    public String toString() {
        return "%d.%d.%d".formatted(this.major, this.minor, this.patch);
    }

    public boolean isInvalid() {
        return this == INVALID;
    }
}

