/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.entity;

import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import net.lopymine.patpat.client.config.resourcepack.CustomAnimationSettingsConfig;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.minecraft.class_1309;

public class PatEntity {
    private final class_1309 entity;
    private final CustomAnimationSettingsConfig animation;
    private int currentFrame;
    private int tickProgress;

    public PatEntity(class_1309 entity, PlayerConfig whoPatted) {
        this.entity = entity;
        this.animation = CustomAnimationSettingsConfig.of(entity, whoPatted);
        this.currentFrame = 0;
        this.tickProgress = -1;
    }

    public void resetAnimation() {
        this.currentFrame = 0;
        this.tickProgress = -1;
    }

    public void tick() {
        ++this.tickProgress;
        if (this.tickProgress == Integer.MAX_VALUE) {
            this.tickProgress = 0;
        }
    }

    public float getProgress(float tickDelta) {
        float v = (float)Math.max(this.tickProgress, 0) * 50.0f;
        float v1 = tickDelta * 50.0f;
        return v + v1;
    }

    public boolean is(class_1309 entity) {
        return this.is(entity.method_5667());
    }

    private boolean is(UUID uuid) {
        return this.entity.method_5667().equals(uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatEntity patEntity = (PatEntity)o;
        return this.is(patEntity.getEntity());
    }

    public int hashCode() {
        return Objects.hash(this.entity.method_5667());
    }

    public String toString() {
        return "PatEntity{entity=" + this.entity.toString() + ", animation=" + this.animation.toString() + ", currentFrame=" + this.currentFrame + ", tickProgress=" + this.tickProgress + "}";
    }

    @Generated
    public class_1309 getEntity() {
        return this.entity;
    }

    @Generated
    public CustomAnimationSettingsConfig getAnimation() {
        return this.animation;
    }

    @Generated
    public int getCurrentFrame() {
        return this.currentFrame;
    }

    @Generated
    public int getTickProgress() {
        return this.tickProgress;
    }

    @Generated
    public void setCurrentFrame(int currentFrame) {
        this.currentFrame = currentFrame;
    }
}

