/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.command.argument;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.command.PatPatClientCommandManager;
import net.lopymine.patpat.extension.GameProfileExtension;
import net.lopymine.patpat.utils.CommandText;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;

public class PlayerInfoArgumentType
implements ArgumentType<PlayerInfo> {
    public static final DynamicCommandExceptionType FAILED_PARSING = new DynamicCommandExceptionType(o -> CommandText.text("error.failed_when_parsing", o).finish());
    public static final DynamicCommandExceptionType UNKNOWN_PLAYER = new DynamicCommandExceptionType(o -> CommandText.text("error.player_not_exist", o).finish());
    private static final Collection<String> EXAMPLES = Arrays.asList("LopyMine", "nikita51", "192e3748-12d5-4573-a8a5-479cd394a1dc", "7b829ed5-9b74-428f-9b4d-ede06975fbc1");

    private PlayerInfoArgumentType() {
    }

    @NotNull
    public static PlayerInfoArgumentType player() {
        return new PlayerInfoArgumentType();
    }

    public static <S> PlayerInfo getPlayerInfo(String name, @NotNull CommandContext<S> context) {
        return (PlayerInfo)context.getArgument(name, PlayerInfo.class);
    }

    public PlayerInfo parse(@NotNull StringReader reader) throws CommandSyntaxException {
        try {
            String s = reader.readUnquotedString();
            PatPatClientCommandManager.LOGGER.debug("Parsed PlayerInfo from PlayerInfoArgumentType: {}", s);
            class_634 networkHandler = class_310.method_1551().method_1562();
            if (networkHandler == null) {
                PatPatClientCommandManager.LOGGER.debug("networkHandler is null, cannot parse PlayerInfo from PlayerInfoArgumentType!", new Object[0]);
                throw FAILED_PARSING.createWithContext((ImmutableStringReader)reader, (Object)reader.getString());
            }
            for (class_640 entry : networkHandler.method_2880()) {
                UUID uuid;
                GameProfile profile = entry.method_2966();
                if (GameProfileExtension.getName(profile).equals(s)) {
                    PlayerInfo playerInfo = new PlayerInfo(s, GameProfileExtension.getUUID(profile));
                    PatPatClientCommandManager.LOGGER.debug("Found PlayerInfo by nickname from PlayerInfoArgumentType, parsed: {}", playerInfo);
                    return playerInfo;
                }
                try {
                    uuid = UUID.fromString(s);
                }
                catch (Exception e) {
                    PatPatClient.LOGGER.debug("Issue occurred after parsing player uuid from string \"{}\":", s, e);
                    continue;
                }
                if (!GameProfileExtension.getUUID(profile).equals(uuid)) continue;
                PlayerInfo playerInfo = new PlayerInfo(GameProfileExtension.getName(profile), uuid);
                PatPatClientCommandManager.LOGGER.debug("Found PlayerInfo by uuid from PlayerInfoArgumentType, parsed: {}", playerInfo);
                return playerInfo;
            }
            throw UNKNOWN_PLAYER.createWithContext((ImmutableStringReader)reader, (Object)reader.getString());
        }
        catch (CommandSyntaxException e) {
            throw FAILED_PARSING.createWithContext((ImmutableStringReader)reader, (Object)reader.getString());
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record PlayerInfo(String nickname, UUID uuid) {
        @Override
        public String toString() {
            return "PlayerInfo{nickname='" + this.nickname + "', uuid=" + String.valueOf(this.uuid) + "}";
        }
    }
}

