/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.resourcepack;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.client.config.resourcepack.CustomAnimationConfig;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.client.manager.PatPatClientManager;
import net.lopymine.patpat.common.Version;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class PatPatClientResourcePackManager {
    public static final PatLogger LOGGER = PatPatClient.LOGGER.extend("ResourcePackManager");
    public static final PatPatClientResourcePackManager INSTANCE = new PatPatClientResourcePackManager();
    private final List<List<CustomAnimationConfig>> loadedAnimations = new ArrayList<List<CustomAnimationConfig>>();

    private PatPatClientResourcePackManager() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parseConfig(String packName, class_2960 identifier, Supplier<InputStream> inputStreamInputSupplier, List<CustomAnimationConfig> configs, PatPatClientConfig config) {
        String path = identifier.method_12832();
        if (!path.endsWith(".json") && !path.endsWith(".json5")) {
            return;
        }
        try (InputStream inputStream = inputStreamInputSupplier.get();
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            if (!json.isJsonObject()) {
                LOGGER.error("ResourcePack '{}', file '{}' is not a json object, skipping", packName, path);
                return;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement jsonElement = jsonObject.get("version");
            if (jsonElement == null) {
                LOGGER.error("ResourcePack '{}', file '{}' failed to get config version because it's missing, skipping", packName, path);
                return;
            }
            String string = jsonElement.getAsString();
            Version configVersion = Version.of(string);
            if (configVersion.isMoreThan(Version.CURRENT_MOD_VERSION)) {
                LOGGER.warn("ResourcePack '{}', file '{}' has unsupported new version[{} < {}], there may be errors!", packName, path, Version.CURRENT_MOD_VERSION, configVersion);
            } else if (configVersion.isLessThan(Version.RESOURCE_PACKS_MIN_SUPPORT_VERSION)) {
                boolean shouldSkip = config.getResourcePacksConfig().isSkipOldAnimationsEnabled();
                LOGGER.warn("ResourcePack '{}', file '{}' has unsupported old version[{} > {}], {}!", packName, path, Version.RESOURCE_PACKS_MIN_SUPPORT_VERSION, configVersion, shouldSkip ? "skipping" : "there may be errors");
                if (shouldSkip) {
                    return;
                }
            }
            DataResult dataResult = CustomAnimationConfig.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            PatLogger patLogger = LOGGER;
            Objects.requireNonNull(patLogger);
            PatLogger patLogger2 = patLogger;
            CustomAnimationConfig animationConfig = (CustomAnimationConfig)((Pair)dataResult.getOrThrow(false, x$0 -> patLogger2.error((String)x$0, new Object[0]))).getFirst();
            animationConfig.setConfigPath("%s/%s".formatted(packName, path));
            configs.add(animationConfig);
            return;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("ResourcePack '%s', failed to parse file '%s', skipping", packName, path), e);
        }
    }

    public void reload(List<class_3262> reloadPacks, class_3300 manager) {
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        this.loadedAnimations.clear();
        PatPatClientManager.clearPatEntities();
        List<class_3262> packs = reloadPacks.stream().filter(pack -> pack.method_14406(class_3264.field_14188).contains("patpat")).toList();
        ArrayList serverResourcePacks = new ArrayList();
        ArrayList resourcePacks = new ArrayList();
        for (class_3262 pack2 : packs) {
            String resourcePackName = pack2.method_14409();
            ArrayList animationConfigs = new ArrayList();
            LOGGER.info("Registering {} resource pack", resourcePackName);
            pack2.method_14408(class_3264.field_14188, "patpat", "textures", (id, input) -> {
                try (InputStream inputStream = (InputStream)input.get();){
                    PatPatClientResourcePackManager.parseConfig(resourcePackName, id, () -> inputStream, animationConfigs, config);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to read custom animation at {} from {}", id.toString(), resourcePackName);
                }
            });
            if (animationConfigs.isEmpty()) continue;
            animationConfigs.sort(CustomAnimationConfig::compareTo);
            Collections.reverse(animationConfigs);
            if (config.getMultiPlayerConfig().isBypassServerResourcePackPriorityEnabled() && resourcePackName.startsWith("server/")) {
                serverResourcePacks.add(animationConfigs);
                continue;
            }
            resourcePacks.add(animationConfigs);
        }
        this.loadedAnimations.addAll(Lists.reverse(resourcePacks));
        this.loadedAnimations.addAll(Lists.reverse(serverResourcePacks));
    }

    @Nullable
    public CustomAnimationConfig getAnimationConfig(class_1309 entity, PlayerConfig whoPatted) {
        for (List<CustomAnimationConfig> configs : this.loadedAnimations) {
            for (CustomAnimationConfig config : configs) {
                if (!config.canUseFor((class_1297)entity, whoPatted)) continue;
                return config;
            }
        }
        return null;
    }
}

