/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config.migrate;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.client.config.list.PatPatClientPlayerListConfig;
import net.lopymine.patpat.client.config.resourcepack.ListMode;
import net.lopymine.patpat.client.config.sub.PatPatClientMainConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientMultiplayerConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientResourcePacksConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientSoundsConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientVisualConfig;
import net.lopymine.patpat.common.config.vector.Vec3f;
import net.lopymine.patpat.common.migrate.AbstractConfigMigrateHandler;
import net.lopymine.patpat.utils.CodecUtils;
import net.lopymine.patpat.utils.VersionedThings;

public class PatPatClientConfigMigrateVersion0
extends AbstractConfigMigrateHandler {
    private static final String MIGRATE_FILE_NAME = "patpat-client.json5";
    private static final String MIGRATE_VERSION = "0";
    private PatPatClientConfig config = null;
    private PatPatClientPlayerListConfig playerListConfig = null;

    public PatPatClientConfigMigrateVersion0() {
        super(MIGRATE_FILE_NAME, MIGRATE_VERSION, PatPatClient.LOGGER);
    }

    @Override
    public boolean needToMigrateFile() {
        try {
            File migrateFile = this.getMigrateFile().toFile();
            JsonObject object = (JsonObject)GSON.fromJson(new JsonReader((Reader)new FileReader(migrateFile)), JsonObject.class);
            return !object.has("version");
        }
        catch (FileNotFoundException e) {
            this.getLogger().error("[MigrateVersion0] Not found file for migrate", e);
            return false;
        }
    }

    @Override
    public boolean migrateFile() {
        try {
            File migrateFile = this.getMigrateFile().toFile();
            JsonObject object = (JsonObject)GSON.fromJson(new JsonReader((Reader)new FileReader(migrateFile)), JsonObject.class);
            PatPatClientConfig clientConfig = this.config == null ? PatPatClientConfig.getInstance() : this.config;
            PatPatClientPlayerListConfig clientPlayerListConfig = this.playerListConfig == null ? PatPatClientPlayerListConfig.getInstance() : this.playerListConfig;
            this.migrateFields(object, clientConfig, clientPlayerListConfig);
            return true;
        }
        catch (FileNotFoundException e) {
            this.getLogger().error("[MigrateVersion0] Not found file for migrate", e);
            return false;
        }
    }

    private void migrateFields(JsonObject object, PatPatClientConfig config, PatPatClientPlayerListConfig playerListConfig) {
        HashMap list = (HashMap)CodecUtils.decode("list", Codec.unboundedMap(VersionedThings.UUID_CODEC, (Codec)Codec.STRING).xmap(HashMap::new, HashMap::new), object);
        Boolean bypassServerResourcePackPriorityEnabled = (Boolean)CodecUtils.decode("bypassServerResourcePackPriorityEnabled", Codec.BOOL, object);
        Boolean hidingNicknameEnabled = (Boolean)CodecUtils.decode("hidingNicknameEnabled", Codec.BOOL, object);
        Boolean swingHandEnabled = (Boolean)CodecUtils.decode("swingHandEnabled", Codec.BOOL, object);
        Boolean soundsEnabled = (Boolean)CodecUtils.decode("soundsEnabled", Codec.BOOL, object);
        Boolean patMeEnabled = (Boolean)CodecUtils.decode("patMeEnabled", Codec.BOOL, object);
        Boolean cameraShackingEnabled = (Boolean)CodecUtils.decode("cameraShackingEnabled", Codec.BOOL, object);
        Boolean modEnabled = (Boolean)CodecUtils.decode("modEnabled", Codec.BOOL, object);
        Float soundsVolume = (Float)CodecUtils.decode("soundsVolume", Codec.FLOAT, object);
        ListMode listMode = CodecUtils.decode("listMode", ListMode.CODEC, object);
        Float offsetX = (Float)CodecUtils.decode("offsetX", Codec.FLOAT, object);
        Float offsetY = (Float)CodecUtils.decode("offsetY", Codec.FLOAT, object);
        Float offsetZ = (Float)CodecUtils.decode("offsetZ", Codec.FLOAT, object);
        Boolean debugLogEnabled = (Boolean)CodecUtils.decode("debugLogEnabled", Codec.BOOL, object);
        Boolean skipOldAnimationsEnabled = (Boolean)CodecUtils.decode("skipOldAnimationsEnabled", Codec.BOOL, object);
        Float patWeight = (Float)CodecUtils.decode("patWeight", Codec.FLOAT, object);
        PatPatClientSoundsConfig soundsConfig = config.getSoundsConfig();
        if (soundsEnabled != null) {
            soundsConfig.setSoundsEnabled(soundsEnabled);
        }
        if (soundsVolume != null) {
            soundsConfig.setSoundsVolume(soundsVolume.floatValue());
        }
        PatPatClientMainConfig mainConfig = config.getMainConfig();
        if (debugLogEnabled != null) {
            mainConfig.setDebugLogEnabled(debugLogEnabled);
        }
        if (modEnabled != null) {
            mainConfig.setModEnabled(modEnabled);
        }
        PatPatClientMultiplayerConfig serverConfig = config.getMultiPlayerConfig();
        if (bypassServerResourcePackPriorityEnabled != null) {
            serverConfig.setBypassServerResourcePackEnabled(bypassServerResourcePackPriorityEnabled);
        }
        if (patMeEnabled != null) {
            serverConfig.setPatMeEnabled(patMeEnabled);
        }
        if (listMode != null) {
            serverConfig.setListMode(listMode);
        }
        if (list != null) {
            Map<UUID, String> map = playerListConfig.getValues();
            map.clear();
            map.putAll(list);
        }
        PatPatClientVisualConfig visualConfig = config.getVisualConfig();
        if (patWeight != null) {
            visualConfig.setPatWeight(patWeight.floatValue());
        }
        if (offsetX != null && offsetY != null && offsetZ != null) {
            visualConfig.setAnimationOffsets(new Vec3f(offsetX.floatValue(), offsetY.floatValue(), offsetZ.floatValue()));
        }
        if (cameraShackingEnabled != null) {
            visualConfig.setCameraShackingEnabled(cameraShackingEnabled);
        }
        if (swingHandEnabled != null) {
            visualConfig.setClientSwingHandEnabled(swingHandEnabled);
            visualConfig.setServerSwingHandEnabled(swingHandEnabled);
        }
        if (hidingNicknameEnabled != null) {
            visualConfig.setHidingNicknameEnabled(hidingNicknameEnabled);
        }
        PatPatClientResourcePacksConfig resourcePacksConfig = config.getResourcePacksConfig();
        if (skipOldAnimationsEnabled != null) {
            resourcePacksConfig.setSkipOldAnimationsEnabled(skipOldAnimationsEnabled);
        }
        if (this.isShouldSave()) {
            config.save();
            playerListConfig.save();
        }
    }

    public void setConfig(PatPatClientConfig config) {
        this.config = config;
    }

    public void setPlayerListConfig(PatPatClientPlayerListConfig playerListConfig) {
        this.playerListConfig = playerListConfig;
    }
}

