/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.resourcepack.CustomAnimationConfig;
import net.lopymine.patpat.client.config.resourcepack.FrameConfig;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.client.config.resourcepack.SoundConfig;
import net.lopymine.patpat.client.resourcepack.PatPatClientResourcePackManager;
import net.lopymine.patpat.utils.IdentifierUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.jetbrains.annotations.Nullable;

public final class CustomAnimationSettingsConfig {
    public static final Codec<CustomAnimationSettingsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("texture").xmap(IdentifierUtils::vanillaId, class_2960::toString).forGetter(CustomAnimationSettingsConfig::getTexture), (App)Codec.INT.fieldOf("duration").forGetter(CustomAnimationSettingsConfig::getDuration), (App)FrameConfig.CODEC.fieldOf("frame").forGetter(CustomAnimationSettingsConfig::getFrameConfig), (App)SoundConfig.STRINGED_CODEC.optionalFieldOf("sound").forGetter(CustomAnimationSettingsConfig::getOptionalSoundConfig)).apply((Applicative)instance, CustomAnimationSettingsConfig::new));
    public static final CustomAnimationSettingsConfig DEFAULT_PATPAT_ANIMATION = new CustomAnimationSettingsConfig(IdentifierUtils.modId("textures/default/patpat.png"), 240, FrameConfig.DEFAULT_FRAME, Optional.of(SoundConfig.PAT_PAT_SOUND));
    private final class_2960 texture;
    private final int duration;
    private final FrameConfig frameConfig;
    @Nullable
    private final SoundConfig soundConfig;
    private int textureWidth;
    private int textureHeight;

    public CustomAnimationSettingsConfig(class_2960 texture, int duration, FrameConfig frameConfig, Optional<SoundConfig> soundConfig) {
        this.texture = texture;
        this.duration = duration;
        this.frameConfig = frameConfig;
        this.soundConfig = soundConfig.orElse(null);
        this.loadSize();
    }

    public static CustomAnimationSettingsConfig of(class_1309 entity, PlayerConfig whoPatted) {
        PatPatClientResourcePackManager manager = PatPatClientResourcePackManager.INSTANCE;
        CustomAnimationConfig config = manager.getAnimationConfig(entity, whoPatted);
        if (config != null) {
            return config.getAnimation();
        }
        return DEFAULT_PATPAT_ANIMATION;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CustomAnimationSettingsConfig that = (CustomAnimationSettingsConfig)obj;
        return Objects.equals(this.texture, that.texture) && this.duration == that.duration && Objects.equals(this.frameConfig, that.frameConfig) && Objects.equals(this.soundConfig, that.soundConfig);
    }

    public int hashCode() {
        return Objects.hash(this.texture, this.duration, this.frameConfig, this.soundConfig);
    }

    public String toString() {
        return "CustomAnimationSettingsConfig[texture=" + String.valueOf(this.texture) + ", duration=" + this.duration + ", frameConfig=" + String.valueOf(this.frameConfig) + ", soundConfig=" + String.valueOf(this.soundConfig) + "]";
    }

    private void loadSize() {
        try {
            class_3298 resource = class_310.method_1551().method_1478().method_14486(this.texture);
            InputStream inputStream = resource.method_14482();
            class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
            this.textureWidth = nativeImage.method_4307();
            this.textureHeight = nativeImage.method_4323();
        }
        catch (IOException e) {
            PatPatClient.LOGGER.error("Failed to load texture size from custom animation: ", e);
        }
    }

    private Optional<SoundConfig> getOptionalSoundConfig() {
        return Optional.ofNullable(this.soundConfig);
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public int getDuration() {
        return this.duration;
    }

    public FrameConfig getFrameConfig() {
        return this.frameConfig;
    }

    @Nullable
    public SoundConfig getSoundConfig() {
        return this.soundConfig;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }
}

