/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.utils.CodecUtils;

public class ConfigUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private static String generateUniqueBackupName(Path parentDir, String fileName) {
        Object backupName = fileName + ".bkp";
        int index = 0;
        while (Files.exists(parentDir.resolve((String)backupName), new LinkOption[0])) {
            backupName = String.format("%s-%d.bkp", fileName, ++index);
        }
        return backupName;
    }

    private static void createBackup(File file) {
        try {
            Path fileFolder = file.toPath().getParent();
            String filename = file.getName();
            String backupFileName = ConfigUtils.generateUniqueBackupName(fileFolder, filename);
            Path backupPath = fileFolder.resolve(backupFileName);
            Files.copy(file.toPath(), backupPath, new CopyOption[0]);
        }
        catch (Exception e) {
            PatPat.LOGGER.error("Failed to backup config", e);
        }
    }

    private static <A> A create(Codec<A> codec, File location, PatLogger logger) {
        A config = CodecUtils.parseNewInstanceHacky(codec);
        if (location.exists()) {
            logger.error("Invoked create config method, but config already exists!", new Object[0]);
            return config;
        }
        try (FileWriter writer = new FileWriter(location, StandardCharsets.UTF_8);){
            String json = GSON.toJson((JsonElement)codec.encode(config, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, x$0 -> logger.error((String)x$0, new Object[0])));
            writer.write(json);
        }
        catch (Exception e) {
            logger.error("Failed to create config", e);
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <A> A readConfig(Codec<A> codec, File location, PatLogger logger) {
        if (!location.exists()) {
            return ConfigUtils.create(codec, location, logger);
        }
        try (FileReader reader = new FileReader(location, StandardCharsets.UTF_8);){
            Object object = ((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)reader)).getOrThrow(false, x$0 -> logger.error((String)x$0, new Object[0]))).getFirst();
            return (A)object;
        }
        catch (Exception e) {
            logger.error("Failed to read config", e);
            ConfigUtils.createBackup(location);
            return ConfigUtils.create(codec, location, logger);
        }
    }

    public static <A> void saveConfig(A config, Codec<A> codec, File location, PatLogger logger) {
        logger.debug("Saving config...", new Object[0]);
        try (FileWriter writer = new FileWriter(location, StandardCharsets.UTF_8);){
            String json = GSON.toJson((JsonElement)codec.encode(config, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, x$0 -> logger.error((String)x$0, new Object[0])));
            writer.write(json);
        }
        catch (Exception e) {
            logger.error("Failed to save config:", e);
        }
        logger.debug("Config saved", new Object[0]);
    }
}

