/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.lopymine.patpat.plugin.config.PatPatConfig;

public class PatLogger {
    public static final Logger LOGGER = Logger.getLogger("patpat-plugin");

    private PatLogger() {
        throw new IllegalStateException("Logger class");
    }

    public static void info(String message, Object ... args) {
        message = PatLogger.format(message, args);
        LOGGER.info(message);
    }

    public static void warn(String message, Exception e) {
        LOGGER.log(Level.WARNING, message, e);
    }

    public static void warn(String message, Object ... args) {
        message = PatLogger.format(message, args);
        LOGGER.warning(message);
    }

    public static void error(String message, Exception e) {
        LOGGER.log(Level.SEVERE, message, e);
    }

    public static void error(String message, Object ... args) {
        message = PatLogger.format(message, args);
        LOGGER.severe(message);
    }

    public static void debug(String message, Object ... args) {
        if (!PatPatConfig.getInstance().isDebug()) {
            return;
        }
        message = "[DEBUG]: " + PatLogger.format((String)message, args);
        LOGGER.info((String)message);
    }

    private static String format(String message, Object ... args) {
        if (args.length != 0) {
            return message.formatted(args);
        }
        return message;
    }
}

