/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.util.ResourceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatTranslator
implements Translator {
    private static final String DEFAULT_LANG = "en_US";
    private static final String LANG_FOLDER = "lang/";
    private static final String LANG_FILETYPE = ".json";
    private final Map<String, Map<String, String>> localizations = new HashMap<String, Map<String, String>>();
    private static PatTranslator instance;

    public static PatTranslator getInstance() {
        if (instance == null) {
            instance = new PatTranslator();
        }
        return instance;
    }

    public static void register() {
        GlobalTranslator.translator().addSource(PatTranslator.getInstance());
    }

    public static void unregister() {
        if (instance != null) {
            GlobalTranslator.translator().removeSource(instance);
            instance = null;
        }
    }

    public PatTranslator() {
        this.registerInternalLangs();
        this.registerExternalLangs();
    }

    private void registerInternalLangs() {
        List<String> filenames = PatTranslator.getInternalLangFiles();
        for (String filename : filenames) {
            this.readLangResourceFromJar(filename);
        }
    }

    private static List<String> getInternalLangFiles() throws IOException {
        URL url = ((Object)((Object)PatPatPlugin.getInstance())).getClass().getClassLoader().getResource(LANG_FOLDER);
        if (url == null) {
            return Collections.emptyList();
        }
        if (!Objects.equals(url.getProtocol(), "jar")) {
            return Collections.emptyList();
        }
        JarURLConnection connection = (JarURLConnection)url.openConnection();
        try (JarFile jar = connection.getJarFile();){
            List<String> result = ((Stream)jar.stream().sequential()).filter(entry -> !entry.isDirectory() && entry.getName().startsWith(LANG_FOLDER) && entry.getName().endsWith(LANG_FILETYPE)).map(ZipEntry::getName).map(str -> str.substring(LANG_FOLDER.length(), str.length() - LANG_FILETYPE.length())).toList();
            PatLogger.debug("Found internal lang files: " + String.valueOf(result), new Object[0]);
            List<String> list = result;
            return list;
        }
    }

    private void readLangResourceFromJar(String lang) {
        Map<String, String> langResource = ResourceUtils.loadLangFromJar("%s%s%s".formatted(LANG_FOLDER, lang, LANG_FILETYPE));
        if (langResource == null) {
            return;
        }
        langResource.replaceAll((k, v) -> ((String)langResource.get(k)).replace("'", "''"));
        this.localizations.computeIfAbsent(lang, k -> new HashMap()).putAll(langResource);
    }

    private void registerExternalLangs() {
        File langFolder = new File(PatPatPlugin.getInstance().getDataFolder(), "lang");
        if (!langFolder.exists() && !langFolder.isDirectory()) {
            return;
        }
        File[] jsonFiles = langFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(LANG_FILETYPE) && new File(dir, name).isFile());
        if (jsonFiles == null) {
            return;
        }
        PatLogger.debug("Found external lang files: " + String.valueOf(Arrays.stream(jsonFiles).map(File::getName).toList()), new Object[0]);
        for (File jsonFile : jsonFiles) {
            String name2 = jsonFile.getName();
            String lang = name2.substring(0, name2.length() - LANG_FILETYPE.length());
            Map<String, String> langResource = ResourceUtils.loadLang(jsonFile);
            if (langResource == null) {
                return;
            }
            PatLogger.info(lang, new Object[0]);
            langResource.replaceAll((k, v) -> ((String)langResource.get(k)).replace("'", "''"));
            this.localizations.computeIfAbsent(lang, k -> new HashMap()).putAll(langResource);
        }
    }

    @Override
    @NotNull
    public Key name() {
        return Key.key("patpat:translator");
    }

    @Override
    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        if (!key.startsWith("patpat")) {
            return null;
        }
        String lang = locale.toString();
        Map localization = this.localizations.getOrDefault(lang, null);
        if (localization == null) {
            String message = this.localizations.get(DEFAULT_LANG).getOrDefault(key, null);
            return message == null ? null : new MessageFormat(message);
        }
        String message = localization.getOrDefault(key, this.localizations.get(DEFAULT_LANG).getOrDefault(key, null));
        return message == null ? null : new MessageFormat(message);
    }
}

