/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.command.api.ChildCommand;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.command.api.SimpleCommand;
import net.lopymine.patpat.plugin.command.info.InfoCommand;
import net.lopymine.patpat.plugin.command.list.ListAddCommand;
import net.lopymine.patpat.plugin.command.list.ListInfoCommand;
import net.lopymine.patpat.plugin.command.list.ListRemoveCommand;
import net.lopymine.patpat.plugin.command.list.ListSetCommand;
import net.lopymine.patpat.plugin.command.ratelimit.RateLimitDisableCommand;
import net.lopymine.patpat.plugin.command.ratelimit.RateLimitEnableCommand;
import net.lopymine.patpat.plugin.command.ratelimit.RateLimitInfoCommand;
import net.lopymine.patpat.plugin.command.ratelimit.set.IncrementCommand;
import net.lopymine.patpat.plugin.command.ratelimit.set.IntervalCommand;
import net.lopymine.patpat.plugin.command.ratelimit.set.LimitCommand;
import net.lopymine.patpat.plugin.command.reload.ReloadCommand;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;

public class PatPatCommandManager {
    private static final Component NO_PERMISSION_MESSAGE = Component.translatable("patpat.command.no_permission").color(NamedTextColor.RED);

    private PatPatCommandManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        SimpleCommand listCommand = PatPatCommandManager.registerListCommand();
        SimpleCommand rateLimitCommand = PatPatCommandManager.registerRateLimitCommand();
        SimpleCommand reloadCommand = PatPatCommandManager.getSimpleCommand(new ReloadCommand());
        SimpleCommand infoCommand = PatPatCommandManager.getSimpleCommand(new InfoCommand());
        SimpleCommand rootCommand = SimpleCommand.builder().usage("/patpat (info | list | ratelimit | reload)").child(listCommand, "list", new String[0]).child(rateLimitCommand, "ratelimit", new String[0]).child(reloadCommand, "reload", new String[0]).child(infoCommand, "info", new String[0]).build();
        PatPatPlugin plugin = PatPatPlugin.getInstance();
        PluginCommand command = plugin.getCommand("patpat");
        Objects.requireNonNull(command, "Command `patpat` is not registered");
        command.setExecutor((CommandExecutor)rootCommand);
    }

    private static SimpleCommand registerListCommand() {
        SimpleCommand infoCommand = PatPatCommandManager.getSimpleCommand(new ListInfoCommand());
        SimpleCommand setModeCommand = PatPatCommandManager.getSimpleCommand(new ListSetCommand());
        SimpleCommand addToListCommand = PatPatCommandManager.getSimpleCommand(new ListAddCommand());
        SimpleCommand removeFromListCommand = PatPatCommandManager.getSimpleCommand(new ListRemoveCommand());
        return SimpleCommand.builder().permission(StringUtils.permission("list")).usage("/patpat list (info | set | add | remove)").child(infoCommand, "info", new String[0]).child(setModeCommand, "set", new String[0]).child(addToListCommand, "add", new String[0]).child(removeFromListCommand, "remove", new String[0]).msgNoPermission(NO_PERMISSION_MESSAGE).build();
    }

    private static SimpleCommand registerRateLimitCommand() {
        SimpleCommand infoCommand = PatPatCommandManager.getSimpleCommand(new RateLimitInfoCommand());
        SimpleCommand enableCommand = PatPatCommandManager.getSimpleCommand(new RateLimitEnableCommand());
        SimpleCommand disableCommand = PatPatCommandManager.getSimpleCommand(new RateLimitDisableCommand());
        SimpleCommand incrementCommand = PatPatCommandManager.getSimpleCommand(new IncrementCommand());
        SimpleCommand intervalCommand = PatPatCommandManager.getSimpleCommand(new IntervalCommand());
        SimpleCommand limitCommand = PatPatCommandManager.getSimpleCommand(new LimitCommand());
        SimpleCommand setCommand = SimpleCommand.builder().permission(StringUtils.permission("ratelimit.set")).usage("/patpat ratelimit set (increment | interval | limit)").child(incrementCommand, "increment", new String[0]).child(intervalCommand, "interval", new String[0]).child(limitCommand, "limit", new String[0]).msgNoPermission(NO_PERMISSION_MESSAGE).build();
        return SimpleCommand.builder().permission(StringUtils.permission("ratelimit")).usage("/patpat ratelimit (enable | disable | set | info)").child(enableCommand, "enable", "on").child(disableCommand, "disable", "off").child(infoCommand, "info", new String[0]).child(setCommand, "set", new String[0]).msgNoPermission(NO_PERMISSION_MESSAGE).build();
    }

    public static SimpleCommand getSimpleCommand(ICommand command) {
        return SimpleCommand.builder().permission(command.getPermissionKey()).usage(command.getExampleOfUsage()).msgNoPermission(NO_PERMISSION_MESSAGE).description(command.getDescription()).executor(command).build();
    }

    public static SimpleCommand getSimpleCommand(ICommand command, ChildCommand ... childCommands) {
        SimpleCommand.Builder simpleCommandBuilder = SimpleCommand.builder().permission(command.getPermissionKey()).usage(command.getExampleOfUsage()).msgNoPermission(NO_PERMISSION_MESSAGE).description(command.getDescription()).executor(command);
        for (ChildCommand childCommand : childCommands) {
            simpleCommandBuilder.child(childCommand.getCommand(), childCommand.getName(), childCommand.getAliases());
        }
        return simpleCommandBuilder.build();
    }

    public static void sendMessage(CommandSender sender, String message, Object ... args) {
        sender.sendMessage(PatPatCommandManager.getPluginMessage(message.formatted(args)));
    }

    public static String getPluginMessage(String message) {
        return "[\u00a7aPatPat\u00a7f] " + message;
    }
}

