/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.api;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.lopymine.patpat.plugin.command.PatPatCommandManager;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.extension.CommandSenderExtension;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleCommand
implements TabExecutor {
    private final Component description;
    private final String msgOnlyForPlayer;
    private final Component msgNoPermission;
    private final String usage;
    private final String permission;
    private final ICommand command;
    private final Map<String, SimpleCommand> child;
    private final boolean onlyForPlayer;

    private SimpleCommand(@Nullable ICommand command, @Nullable Component description, boolean onlyForPlayer, @Nullable String msgOnlyForPlayer, @Nullable Component msgNoPermission, @Nullable String usage, @Nullable String permission, @Nullable Map<String, SimpleCommand> child) {
        this.command = command;
        this.usage = usage;
        this.permission = permission;
        this.description = description;
        this.onlyForPlayer = onlyForPlayer;
        this.msgOnlyForPlayer = msgOnlyForPlayer;
        this.msgNoPermission = msgNoPermission;
        this.child = Objects.requireNonNullElseGet(child, HashMap::new);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void printDescription(@NotNull CommandSender sender) {
        if (this.permission == null || sender.hasPermission(this.permission)) {
            if (this.description != null) {
                CommandSenderExtension.sendMsg(sender, this.description);
            }
            this.child.values().forEach(simpleCommand -> simpleCommand.printDescription(sender));
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        try {
            if (this.onlyForPlayer && !(sender instanceof Player)) {
                if (this.msgOnlyForPlayer != null) {
                    sender.sendMessage(this.msgOnlyForPlayer);
                }
                return false;
            }
            if (this.permission == null || sender.hasPermission(this.permission)) {
                SimpleCommand simpleCommand;
                if (args.length == 0) {
                    this.accept(sender, args);
                    return true;
                }
                String[] cropArgs = new String[args.length - 1];
                if (cropArgs.length > 0) {
                    System.arraycopy(args, 1, cropArgs, 0, cropArgs.length);
                }
                if ((simpleCommand = this.child.get(args[0].toLowerCase(Locale.ROOT))) != null) {
                    simpleCommand.onCommand(sender, command, label, cropArgs);
                    return true;
                }
                this.accept(sender, args);
                return true;
            }
            if (this.msgNoPermission != null) {
                CommandSenderExtension.sendMsg(sender, this.msgNoPermission);
            }
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    private void accept(@NotNull CommandSender sender, @NotNull String[] args) {
        if (this.command != null) {
            this.command.execute(sender, args);
        } else if (this.usage != null) {
            PatPatCommandManager.sendMessage(sender, this.usage, new Object[0]);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        String cmd = args[0].toLowerCase(Locale.ROOT);
        SimpleCommand simpleCommand = this.child.get(cmd);
        if (simpleCommand != null) {
            if (args.length > 1) {
                String[] cropArgs = new String[args.length - 1];
                System.arraycopy(args, 1, cropArgs, 0, cropArgs.length);
                return simpleCommand.onTabComplete(sender, command, label, cropArgs);
            }
            return Collections.emptyList();
        }
        if (this.command != null) {
            return this.command.getSuggestions(sender, args);
        }
        return this.child.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(cmd)).filter(e -> {
            String perm = ((SimpleCommand)e.getValue()).permission;
            return perm == null || sender.hasPermission(perm);
        }).map(Map.Entry::getKey).toList();
    }

    public static final class Builder {
        @Nullable
        private Component description;
        private boolean onlyForPlayer = false;
        @Nullable
        private String msgOnlyForPlayer;
        @Nullable
        private Component msgNoPermission;
        @Nullable
        private String usage;
        @Nullable
        private String permission;
        @Nullable
        private ICommand command;
        @Nullable
        private Map<String, SimpleCommand> childCommandMap;

        private Builder() {
        }

        public Builder description(@Nullable Component description) {
            this.description = description;
            return this;
        }

        public Builder onlyForPlayer() {
            this.onlyForPlayer = true;
            return this;
        }

        public Builder msgOnlyForPlayer(@Nullable String msgOnlyForPlayer) {
            this.msgOnlyForPlayer = msgOnlyForPlayer;
            return this;
        }

        public Builder msgNoPermission(@Nullable Component msgNoPermission) {
            this.msgNoPermission = msgNoPermission;
            return this;
        }

        public Builder usage(@Nullable String usage) {
            this.usage = usage;
            return this;
        }

        public Builder permission(@Nullable String permission) {
            this.permission = permission;
            return this;
        }

        public Builder executor(@Nullable ICommand executor) {
            this.command = executor;
            return this;
        }

        public Builder child(@NotNull SimpleCommand child, @NotNull String name, String ... aliases) {
            if (this.childCommandMap == null) {
                this.childCommandMap = new HashMap<String, SimpleCommand>();
            }
            this.childCommandMap.put(name.toLowerCase(Locale.ROOT), child);
            for (String alias : aliases) {
                this.childCommandMap.put(alias.toLowerCase(Locale.ROOT), child);
            }
            return this;
        }

        @NotNull
        public SimpleCommand build() {
            if (this.childCommandMap == null || this.childCommandMap.isEmpty()) {
                Preconditions.checkNotNull((Object)this.command, (Object)"An executor is required");
            }
            return new SimpleCommand(this.command, this.description, this.onlyForPlayer, this.msgOnlyForPlayer, this.msgNoPermission, this.usage, this.permission, this.childCommandMap);
        }
    }
}

