/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.info;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleSetter;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.extension.CommandSenderExtension;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class InfoCommand
implements ICommand {
    private final Component platformComponent;
    private final Component pluginVersionComponent;
    private final Component minecraftVersionComponent;

    public InfoCommand() {
        String pluginVersion = PatPatPlugin.getInstance().getDescription().getVersion();
        String platformVersion = Bukkit.getServer().getName();
        String minecraftVersion = Bukkit.getServer().getVersion();
        String debugInformation = "Platform: %s%nMinecraft: %s%nVersion: %s".formatted(platformVersion, minecraftVersion, pluginVersion);
        ClickEvent clickEvent = ClickEvent.clickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, debugInformation);
        HoverEvent<Component> hoverEvent = HoverEvent.showText(Component.translatable("patpat.command.info.copy"));
        StyleSetter style = ((TextComponent)Component.empty().clickEvent(clickEvent)).hoverEvent(hoverEvent);
        this.platformComponent = Component.translatable("patpat.command.info.platform").args(Component.text(platformVersion).color(NamedTextColor.GOLD)).mergeStyle((Component)style);
        this.pluginVersionComponent = Component.translatable("patpat.command.info.version").args(Component.text(pluginVersion).color(NamedTextColor.GOLD)).mergeStyle((Component)style);
        this.minecraftVersionComponent = Component.translatable("patpat.command.info.minecraft_version").args(Component.text(minecraftVersion).color(NamedTextColor.GOLD)).mergeStyle((Component)style);
    }

    @Override
    public List<String> getSuggestions(CommandSender commandSender, String[] strings) {
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] strings) {
        CommandSenderExtension.sendMsg(sender, this.platformComponent);
        CommandSenderExtension.sendMsg(sender, this.minecraftVersionComponent);
        CommandSenderExtension.sendMsg(sender, this.pluginVersionComponent);
    }

    @Override
    public String getPermissionKey() {
        return StringUtils.permission("info");
    }

    @Override
    public String getExampleOfUsage() {
        return "/patpat info";
    }

    @Override
    public Component getDescription() {
        return Component.translatable("patpat.command.info.description");
    }
}

