/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.list;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.config.PlayerListConfig;
import net.lopymine.patpat.plugin.extension.CommandSenderExtension;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class ListAddCommand
implements ICommand {
    @Override
    public List<String> getSuggestions(CommandSender sender, String[] strings) {
        if (strings.length != 1) {
            return Collections.emptyList();
        }
        String prefix = strings[0].toLowerCase();
        return Bukkit.getOnlinePlayers().stream().flatMap(player -> Stream.of(player.getName(), player.getUniqueId().toString())).filter(s -> s.toLowerCase().startsWith(prefix)).toList();
    }

    @Override
    public void execute(CommandSender sender, String[] strings) {
        if (strings.length == 0) {
            CommandSenderExtension.sendMsg(sender, this.getExampleOfUsage(), new ComponentLike[0]);
        }
        String value = strings[0];
        try {
            UUID uuid = UUID.fromString(value);
            this.addUuid(sender, uuid);
        }
        catch (IllegalArgumentException ignored) {
            this.addName(sender, value);
        }
    }

    private void addUuid(CommandSender sender, UUID uuid) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        String nickname = offlinePlayer.getName();
        if (nickname == null) {
            nickname = "?";
        }
        this.addPlayer(sender, uuid, nickname);
    }

    private void addName(CommandSender sender, String nickname) {
        OfflinePlayer offlinePlayer = null;
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!nickname.equals(player.getName())) continue;
            offlinePlayer = player;
            break;
        }
        if (offlinePlayer == null) {
            CommandSenderExtension.sendMsg(sender, "patpat.command.error.player_not_exist", Component.text(nickname).color(NamedTextColor.GOLD));
            return;
        }
        this.addPlayer(sender, offlinePlayer.getUniqueId(), nickname);
    }

    private void addPlayer(CommandSender sender, UUID uuid, String nickname) {
        PlayerListConfig config = PlayerListConfig.getInstance();
        TextComponent nicknameComponent = (TextComponent)((TextComponent)((TextComponent)Component.text(nickname).color(NamedTextColor.GOLD)).hoverEvent(HoverEvent.showText(Component.text(uuid.toString())))).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString()));
        if (config.add(uuid, nickname)) {
            TranslatableComponent component = ((TranslatableComponent)Component.translatable("patpat.command.list.add.success").color(NamedTextColor.GREEN)).args(nicknameComponent);
            CommandSenderExtension.sendMsg(sender, component);
            config.save();
        } else {
            CommandSenderExtension.sendMsg(sender, "patpat.command.list.add.already", nicknameComponent);
        }
    }

    @Override
    public String getPermissionKey() {
        return StringUtils.permission("list.add");
    }

    @Override
    public String getExampleOfUsage() {
        return "/patpat list add (<UUID> | <NICKNAME>)";
    }

    @Override
    public Component getDescription() {
        return Component.translatable("patpat.command.list.add.description");
    }
}

