/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.list;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.config.PlayerListConfig;
import net.lopymine.patpat.plugin.extension.CommandSenderExtension;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class ListRemoveCommand
implements ICommand {
    @Override
    public List<String> getSuggestions(CommandSender commandSender, String[] strings) {
        if (strings.length != 1) {
            return Collections.emptyList();
        }
        String prefix = strings[0].toLowerCase();
        return PlayerListConfig.getInstance().getNicknameByUuid().entrySet().stream().map(entry -> {
            if (!Objects.equals(entry.getValue(), "?")) {
                return (String)entry.getValue();
            }
            return ((UUID)entry.getKey()).toString();
        }).filter(s -> s.toLowerCase().startsWith(prefix)).toList();
    }

    @Override
    public void execute(CommandSender sender, String[] strings) {
        if (strings.length == 0) {
            CommandSenderExtension.sendMsg(sender, this.getExampleOfUsage(), new ComponentLike[0]);
            return;
        }
        String value = strings[0];
        try {
            UUID uuid = UUID.fromString(value);
            this.removeUuid(sender, uuid);
        }
        catch (IllegalArgumentException ignored) {
            this.removeName(sender, value);
        }
    }

    private void removeUuid(CommandSender sender, UUID uuid) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        String nickname = offlinePlayer.getName();
        if (nickname == null) {
            PlayerListConfig config = PlayerListConfig.getInstance();
            nickname = config.getNicknameByUuid().getOrDefault(uuid, "?");
        }
        TextComponent nicknameComponent = (TextComponent)((TextComponent)((TextComponent)Component.text(nickname).color(NamedTextColor.GOLD)).hoverEvent(HoverEvent.showText(Component.text(uuid.toString())))).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString()));
        PlayerListConfig config = PlayerListConfig.getInstance();
        if (config.remove(offlinePlayer.getUniqueId())) {
            TranslatableComponent component = ((TranslatableComponent)Component.translatable("patpat.command.list.remove.success").color(NamedTextColor.RED)).args(nicknameComponent);
            CommandSenderExtension.sendMsg(sender, component);
            config.save();
        } else {
            CommandSenderExtension.sendMsg(sender, "patpat.command.list.remove.already", nicknameComponent);
        }
    }

    private void removeName(CommandSender sender, String nickname) {
        PlayerListConfig config = PlayerListConfig.getInstance();
        TextComponent nicknameComponent = (TextComponent)Component.text(nickname).color(NamedTextColor.GOLD);
        if (config.remove(nickname)) {
            TranslatableComponent component = ((TranslatableComponent)Component.translatable("patpat.command.list.remove.success").color(NamedTextColor.RED)).args(nicknameComponent);
            CommandSenderExtension.sendMsg(sender, component);
            config.save();
        } else {
            CommandSenderExtension.sendMsg(sender, "patpat.command.list.remove.already", nicknameComponent);
        }
    }

    @Override
    public String getPermissionKey() {
        return StringUtils.permission("list.remove");
    }

    @Override
    public String getExampleOfUsage() {
        return "/patpat list remove (<UUID> | <NICKNAME>)";
    }

    @Override
    public Component getDescription() {
        return Component.translatable("patpat.command.list.remove.description");
    }
}

