/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.ratelimit;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleSetter;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.command.ratelimit.RateLimitManager;
import net.lopymine.patpat.plugin.config.PatPatConfig;
import net.lopymine.patpat.plugin.config.RateLimitConfig;
import net.lopymine.patpat.plugin.extension.CommandSenderExtension;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RateLimitInfoCommand
implements ICommand {
    private static final Component FORMATTER_ENABLED = Component.translatable("patpat.formatter.enabled_or_disabled.true").color(NamedTextColor.GREEN);
    private static final Component FORMATTER_DISABLED = Component.translatable("patpat.formatter.enabled_or_disabled.false").color(NamedTextColor.RED);

    @Override
    public List<String> getSuggestions(CommandSender sender, String[] strings) {
        if (strings.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.startsWith(strings[0])).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] strings) {
        RateLimitConfig config = PatPatConfig.getInstance().getRateLimit();
        if (strings.length > 0) {
            Player player = Bukkit.getPlayer((String)strings[0]);
            if (player == null) {
                CommandSenderExtension.sendMsg(sender, "patpat.command.error.player_not_exist", Component.text(strings[0]).color(NamedTextColor.GOLD));
                return;
            }
            CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.player", Component.text(strings[0]).color(NamedTextColor.GOLD));
            Component tokensComponent = player.hasPermission(config.getPermissionBypass()) ? Component.translatable("patpat.command.ratelimit.info.tokens.bypass") : Component.text(RateLimitManager.getAvailablePats(player.getUniqueId()));
            tokensComponent = tokensComponent.color(NamedTextColor.GOLD);
            CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.tokens", tokensComponent);
            return;
        }
        Component statusComponent = config.isEnabled() ? FORMATTER_ENABLED : FORMATTER_DISABLED;
        Component limitComponent = Component.text(config.getTokenLimit()).color(NamedTextColor.GOLD);
        Component incrementComponent = Component.text(config.getTokenIncrement()).color(NamedTextColor.GOLD);
        Component intervalComponent = Component.text(config.getTokenInterval().toString()).color(NamedTextColor.GOLD);
        StyleSetter permissionComponent = ((TextComponent)((TextComponent)Component.text(config.getPermissionBypass()).color(NamedTextColor.GOLD)).clickEvent(ClickEvent.clickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, config.getPermissionBypass()))).hoverEvent(HoverEvent.showText(Component.translatable("patpat.command.ratelimit.info.permission_bypass.copy")));
        CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.status", statusComponent);
        CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.limit", limitComponent);
        CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.increment", incrementComponent);
        CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.interval", intervalComponent);
        CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.permission_bypass", new ComponentLike[]{permissionComponent});
    }

    @Override
    public String getPermissionKey() {
        return StringUtils.permission("ratelimit.info");
    }

    @Override
    public String getExampleOfUsage() {
        return "/patpat ratelimit info [<player>]";
    }

    @Override
    public Component getDescription() {
        return Component.translatable("patpat.command.ratelimit.info.description");
    }
}

