/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.ratelimit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.command.ratelimit.Time;
import net.lopymine.patpat.plugin.config.PatPatConfig;
import net.lopymine.patpat.plugin.config.RateLimitConfig;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class RateLimitManager {
    private static BukkitTask task;
    private static final Map<UUID, Integer> uuidToPat;

    private RateLimitManager() {
        throw new IllegalStateException("Manager class");
    }

    public static int getAvailablePats(UUID uuid) {
        return uuidToPat.getOrDefault(uuid, PatPatConfig.getInstance().getRateLimit().getTokenLimit());
    }

    public static boolean canPat(UUID uuid) {
        RateLimitConfig config = PatPatConfig.getInstance().getRateLimit();
        if (!config.isEnabled()) {
            return true;
        }
        int availablePats = uuidToPat.getOrDefault(uuid, config.getTokenLimit()) - 1;
        if (availablePats < 0) {
            return false;
        }
        uuidToPat.put(uuid, availablePats);
        return true;
    }

    public static void addPats(int token) {
        int tokenLimit = PatPatConfig.getInstance().getRateLimit().getTokenLimit();
        Iterator<Map.Entry<UUID, Integer>> it = uuidToPat.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Integer> entry = it.next();
            int value = entry.getValue() + token;
            if (value > tokenLimit) {
                it.remove();
                continue;
            }
            uuidToPat.put(entry.getKey(), value);
        }
    }

    public static void reloadTask() {
        RateLimitConfig config;
        if (task != null) {
            task.cancel();
            task = null;
        }
        if (!(config = PatPatConfig.getInstance().getRateLimit()).isEnabled()) {
            return;
        }
        Time configInterval = config.getTokenInterval();
        long period = (long)(configInterval.getValue() * configInterval.getUnit().getMultiplier()) * 20L;
        task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)PatPatPlugin.getInstance(), () -> RateLimitManager.addPats(config.getTokenIncrement()), 0L, period);
    }

    static {
        uuidToPat = new HashMap<UUID, Integer>();
    }
}

