/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.ratelimit;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.command.ratelimit.RateLimitManager;
import net.lopymine.patpat.plugin.config.PatPatConfig;
import net.lopymine.patpat.plugin.config.RateLimitConfig;
import net.lopymine.patpat.plugin.extension.CommandSenderExtension;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.command.CommandSender;

public abstract class RateLimitToggleCommand
implements ICommand {
    @Override
    public List<String> getSuggestions(CommandSender sender, String[] strings) {
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] strings) {
        PatPatConfig config = PatPatConfig.getInstance();
        RateLimitConfig rateLimitConfig = config.getRateLimit();
        if (rateLimitConfig.isEnabled() == this.getValue()) {
            CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.%s.already".formatted(this.getTranslationKey()), new ComponentLike[0]);
            return;
        }
        rateLimitConfig.setEnabled(this.getValue());
        config.save();
        RateLimitManager.reloadTask();
        CommandSenderExtension.sendMsg(sender, this.getComponent());
    }

    @Override
    public String getPermissionKey() {
        return StringUtils.permission("ratelimit.toggle");
    }

    @Override
    public String getExampleOfUsage() {
        return "/patpat ratelimit %s".formatted(this.getTranslationKey());
    }

    @Override
    public Component getDescription() {
        return Component.translatable("patpat.command.ratelimit.%s.description".formatted(this.getTranslationKey()));
    }

    protected abstract String getTranslationKey();

    protected abstract boolean getValue();

    protected abstract Component getComponent();
}

