/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.command.ratelimit.set;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.lopymine.patpat.plugin.command.api.ICommand;
import net.lopymine.patpat.plugin.config.PatPatConfig;
import net.lopymine.patpat.plugin.config.RateLimitConfig;
import net.lopymine.patpat.plugin.extension.CommandSenderExtension;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.command.CommandSender;

public class IncrementCommand
implements ICommand {
    private static final Component ONE_COMPONENT = Component.text(1).color(NamedTextColor.GOLD);

    @Override
    public List<String> getSuggestions(CommandSender sender, String[] strings) {
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] strings) {
        PatPatConfig config = PatPatConfig.getInstance();
        RateLimitConfig rateLimitConfig = config.getRateLimit();
        if (strings.length == 0) {
            CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.info.increment", Component.text(rateLimitConfig.getTokenIncrement()).color(NamedTextColor.GOLD));
            return;
        }
        if (strings.length > 1) {
            CommandSenderExtension.sendMsg(sender, this.getExampleOfUsage(), new ComponentLike[0]);
            return;
        }
        try {
            int value = Integer.parseInt(strings[0]);
            if (value < 1) {
                CommandSenderExtension.sendMsg(sender, "patpat.command.error.number_less_than", Component.text(value).color(NamedTextColor.GOLD), ONE_COMPONENT);
                return;
            }
            rateLimitConfig.setTokenIncrement(value);
            config.save();
            CommandSenderExtension.sendMsg(sender, "patpat.command.ratelimit.set.increment", Component.text(value).color(NamedTextColor.GOLD));
        }
        catch (NumberFormatException ignored) {
            CommandSenderExtension.sendMsg(sender, "patpat.command.error.not_number", Component.text(strings[0]).color(NamedTextColor.GOLD));
        }
    }

    @Override
    public String getPermissionKey() {
        return StringUtils.permission("ratelimit.set.increment");
    }

    @Override
    public String getExampleOfUsage() {
        return "/patpat ratelimit set increment [value]";
    }

    @Override
    public Component getDescription() {
        return Component.translatable("patpat.command.ratelimit.set.increment.description");
    }
}

