/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.command.ratelimit.RateLimitManager;
import net.lopymine.patpat.plugin.config.InfoConfig;
import net.lopymine.patpat.plugin.config.RateLimitConfig;
import net.lopymine.patpat.plugin.config.option.ListMode;
import org.jetbrains.annotations.Nullable;

public class PatPatConfig {
    private static final String FILENAME = "config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static PatPatConfig instance;
    @SerializedName(value="_info")
    private InfoConfig info;
    private boolean debug = false;
    private ListMode listMode = ListMode.DISABLED;
    private RateLimitConfig rateLimit = new RateLimitConfig();

    public PatPatConfig() {
        this.info = new InfoConfig();
    }

    public static void reload() {
        File configPath = PatPatConfig.getConfigPath();
        if (!configPath.exists()) {
            instance = PatPatConfig.create();
        }
        try (FileReader reader = new FileReader(configPath);){
            instance = (PatPatConfig)GSON.fromJson((Reader)reader, PatPatConfig.class);
        }
        catch (Exception e) {
            PatLogger.error("Failed to read PatPatConfig:", e);
        }
        RateLimitManager.reloadTask();
    }

    private static File getConfigPath() {
        return new File(PatPatPlugin.getInstance().getDataFolder(), FILENAME);
    }

    public void save() {
        this.info.reset();
        String json = GSON.toJson((Object)this, PatPatConfig.class);
        try (FileWriter writer = new FileWriter(PatPatConfig.getConfigPath());){
            writer.write(json);
        }
        catch (Exception e) {
            PatLogger.error("Failed to save PatPatConfig:", e);
        }
    }

    @Nullable
    private static String loadConfigFromJar() {
        String string;
        block9: {
            InputStream inputStream = ((Object)((Object)PatPatPlugin.getInstance())).getClass().getClassLoader().getResourceAsStream(FILENAME);
            try {
                assert (inputStream != null);
                string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    PatLogger.error("Failed to load PatPatConfig from jar!", new Object[0]);
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static PatPatConfig create() {
        String json = PatPatConfig.loadConfigFromJar();
        if (json == null) {
            return null;
        }
        PatPatConfig config = (PatPatConfig)GSON.fromJson(json, PatPatConfig.class);
        try (FileWriter writer = new FileWriter(PatPatConfig.getConfigPath());){
            writer.write(json);
        }
        catch (Exception e) {
            PatLogger.error("Failed to create PatPatConfig:", e);
        }
        return config;
    }

    public InfoConfig getInfo() {
        return this.info;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ListMode getListMode() {
        return this.listMode;
    }

    public RateLimitConfig getRateLimit() {
        return this.rateLimit;
    }

    public void setInfo(InfoConfig info) {
        this.info = info;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setListMode(ListMode listMode) {
        this.listMode = listMode;
    }

    public void setRateLimit(RateLimitConfig rateLimit) {
        this.rateLimit = rateLimit;
    }

    public static PatPatConfig getInstance() {
        return instance;
    }
}

