/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.PatPatPlugin;

public class PlayerListConfig {
    private static PlayerListConfig instance;
    private static final String FILENAME = "player-list.txt";
    private static final File CONFIG_FILE;
    private final Map<UUID, String> nicknameByUuid = new HashMap<UUID, String>();

    public boolean add(UUID uuid, String nickname) {
        return !Objects.equals(this.nicknameByUuid.put(uuid, nickname), nickname);
    }

    public boolean remove(UUID uuid) {
        return this.nicknameByUuid.remove(uuid) != null;
    }

    public boolean remove(String nickname) {
        boolean success = false;
        while (this.nicknameByUuid.containsValue(nickname)) {
            success = true;
            this.nicknameByUuid.values().remove(nickname);
        }
        return success;
    }

    public Set<UUID> getUuids() {
        return this.nicknameByUuid.keySet();
    }

    public Collection<String> getNicknames() {
        return this.nicknameByUuid.values();
    }

    private static boolean create() {
        if (!CONFIG_FILE.exists()) {
            try {
                Files.createFile(CONFIG_FILE.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                PatLogger.error("Failed to create PlayerListConfig:", e);
                return false;
            }
        }
        return CONFIG_FILE.exists();
    }

    public static void reload() {
        if (!PlayerListConfig.create()) {
            PatLogger.error("Failed to reload PlayerListConfig!", new Object[0]);
            return;
        }
        PlayerListConfig config = new PlayerListConfig();
        int lineNumber = 0;
        String line = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG_FILE));){
            line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                String[] uuidNicknamePair = line.split(" ");
                config.nicknameByUuid.put(UUID.fromString(uuidNicknamePair[0]), uuidNicknamePair[1]);
                line = reader.readLine();
            }
            instance = config;
        }
        catch (IllegalArgumentException e) {
            PatLogger.error("Failed to parse line %d in PlayerListConfig: '%s' is not uuid!", lineNumber, line == null ? "null" : line);
        }
        catch (Exception e) {
            PatLogger.error("Failed to reload PlayerListConfig:", e);
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
            writer.write(this.nicknameByUuid.entrySet().stream().map(entry -> "%s %s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("\n")));
        }
        catch (Exception e) {
            PatLogger.error("Failed to save PlayerListConfig:", e);
        }
    }

    public Map<UUID, String> getNicknameByUuid() {
        return this.nicknameByUuid;
    }

    public static PlayerListConfig getInstance() {
        return instance;
    }

    static {
        CONFIG_FILE = new File(PatPatPlugin.getInstance().getDataFolder(), FILENAME);
    }
}

