/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.config.migrate;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.config.PatPatConfig;
import net.lopymine.patpat.plugin.config.Version;
import net.lopymine.patpat.plugin.config.migrate.MigrateHandler;
import net.lopymine.patpat.plugin.config.migrate.MigrateVersion0;

public class MigrateManager {
    private static final String ISSUE_LINK = "https://github.com/LopyMine/PatPat-Plugin/issues";
    private static final Set<MigrateHandler> HANDLERS = new HashSet<MigrateHandler>();
    public static final File CONFIG_FOLDER = PatPatPlugin.getInstance().getDataFolder();

    private MigrateManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void onInitialize() {
        HANDLERS.clear();
        MigrateManager.addHandlers(new MigrateVersion0());
    }

    public static void migrate() {
        MigrateManager.onInitialize();
        for (MigrateHandler handler : HANDLERS) {
            if (!handler.needMigrate()) continue;
            String migrateVersion = handler.getVersion();
            if (!handler.migrate()) {
                PatLogger.error("-----------------------", new Object[0]);
                PatLogger.error("Failed to migrate plugin config from version: %s", migrateVersion);
                PatLogger.error("Report the issue at github page: %s, attaching your config and specifying the mod and server versions.", ISSUE_LINK);
                PatLogger.error("-----------------------", new Object[0]);
                return;
            }
            PatLogger.info("Config successful migrated from version: ", migrateVersion);
        }
    }

    public static void checkVersion() {
        Version version = PatPatConfig.getInstance().getInfo().getVersion();
        if (version.is(Version.SERVER_CONFIG_VERSION)) {
            return;
        }
        if (version.isMoreThan(Version.SERVER_CONFIG_VERSION)) {
            PatLogger.warn("Your config version is higher than the plugin's (%s > %s). This may cause errors!", version, Version.SERVER_CONFIG_VERSION);
            PatLogger.warn("Please update the plugin to avoid issues.", new Object[0]);
            return;
        }
        PatLogger.warn("Your config version is lower than the plugin's (%s < %s). This may cause errors!", version, Version.SERVER_CONFIG_VERSION);
        PatLogger.warn("Back up your config and report the issue at github page: %s, attaching your config and specifying the mod and server versions.", ISSUE_LINK);
    }

    private static void addHandlers(MigrateHandler ... handlers) {
        HANDLERS.addAll(List.of(handlers));
    }
}

