/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.entity;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.ComponentLike;
import net.lopymine.patpat.plugin.config.Version;
import net.lopymine.patpat.plugin.extension.PlayerExtension;
import net.lopymine.patpat.plugin.packet.IPatPacket;
import net.lopymine.patpat.plugin.packet.PatPacketV1;
import net.lopymine.patpat.plugin.packet.handler.PatPacketHandler;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatPlayer {
    private static final Map<Player, PatPlayer> PAT_PLAYERS = new HashMap<Player, PatPlayer>();
    private final Player player;
    private Version version = PatPacketV1.PAT_PACKET_V1_VERSION;
    @Nullable
    private IPatPacket patPacketHandler;

    public PatPlayer(Player player) {
        this(player, PatPacketV1.PAT_PACKET_V1_VERSION);
    }

    public PatPlayer(Player player, Version version) {
        this.player = player;
        this.setVersion(version);
    }

    public static PatPlayer of(@NotNull Player player) {
        return PAT_PLAYERS.computeIfAbsent(player, PatPlayer::new);
    }

    @CanIgnoreReturnValue
    public static PatPlayer register(@NotNull Player player) {
        PatPlayer patPlayer = new PatPlayer(player, PatPacketV1.PAT_PACKET_V1_VERSION);
        PAT_PLAYERS.put(player, patPlayer);
        return patPlayer;
    }

    public static void unregister(@NotNull Player player) {
        PAT_PLAYERS.remove(player);
    }

    public void setVersion(Version version) {
        this.version = version;
        this.updatePatPacketHandler();
    }

    private void updatePatPacketHandler() {
        this.patPacketHandler = PatPacketHandler.getPacketHandler(this);
    }

    public String getName() {
        return this.player.getName();
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte @NotNull [] message) {
        this.player.sendPluginMessage(source, channel, message);
    }

    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    public World getWorld() {
        return this.player.getWorld();
    }

    public void sendPatPatMessage(String message, Object ... args) {
        PlayerExtension.sendPatPatMessage(this.player, message, args);
    }

    public void sendPatPatMessage(ComponentLike message) {
        PlayerExtension.sendPatPatMessage(this.player, message);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Version getVersion() {
        return this.version;
    }

    @Nullable
    public IPatPacket getPatPacketHandler() {
        return this.patPacketHandler;
    }
}

