/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.extension;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ByteArrayDataExtension {
    private ByteArrayDataExtension() {
        throw new IllegalStateException("Extension class");
    }

    public static <T extends ByteArrayDataInput> UUID readUuid(@NotNull T in) {
        return new UUID(in.readLong(), in.readLong());
    }

    public static <T extends ByteArrayDataOutput> void writeUuid(T out, UUID uuid) {
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
    }

    public static <T extends ByteArrayDataInput> int readVarInt(T buf) throws IllegalArgumentException {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = buf.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new IllegalArgumentException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    public static <T extends ByteArrayDataOutput> void writeVarInt(T output, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            output.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        output.writeByte(value);
    }
}

