/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.packet;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.config.Version;
import net.lopymine.patpat.plugin.entity.PatPlayer;
import net.lopymine.patpat.plugin.extension.ByteArrayDataExtension;
import net.lopymine.patpat.plugin.packet.IPatPacket;
import net.lopymine.patpat.plugin.packet.PatPacket;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class PatPacketV2
implements IPatPacket {
    public static final Version PAT_PACKET_V2_VERSION = new Version(1, 2, 0);
    private static final String PACKET_ID = StringUtils.modId("pat_entity_s2c_packet_v2");

    @Override
    public boolean canHandle(PatPlayer player) {
        return player.getVersion().isGreaterOrEqualThan(PAT_PACKET_V2_VERSION);
    }

    @Override
    @Nullable
    public Entity getPattedEntity(PatPlayer sender, ByteArrayDataInput buf) {
        try {
            int entityId = ByteArrayDataExtension.readVarInt(buf);
            for (Entity entity : sender.getWorld().getEntities()) {
                if (entity.getEntityId() != entityId) continue;
                return entity;
            }
        }
        catch (Exception e) {
            PatLogger.warn("Failed to parse entityId from incoming packet from player %s[%s]! Ignoring packet.".formatted(sender.getName(), sender.getUniqueId()), e);
        }
        return null;
    }

    @Override
    public PatPacket getPacket(Entity pattedEntity, Entity whoPattedEntity) {
        ByteArrayDataOutput buf = ByteStreams.newDataOutput();
        ByteArrayDataExtension.writeVarInt(buf, pattedEntity.getEntityId());
        ByteArrayDataExtension.writeVarInt(buf, whoPattedEntity.getEntityId());
        return new PatPacket(buf.toByteArray(), PACKET_ID);
    }

    @Override
    public String getPacketHandlerId() {
        return "PatPacketV2";
    }
}

