/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.packet.handler;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.command.ratelimit.RateLimitManager;
import net.lopymine.patpat.plugin.config.PatPatConfig;
import net.lopymine.patpat.plugin.config.PlayerListConfig;
import net.lopymine.patpat.plugin.config.option.ListMode;
import net.lopymine.patpat.plugin.entity.PatPlayer;
import net.lopymine.patpat.plugin.packet.IPatPacket;
import net.lopymine.patpat.plugin.packet.PatPacket;
import net.lopymine.patpat.plugin.packet.PatPacketV1;
import net.lopymine.patpat.plugin.packet.PatPacketV2;
import net.lopymine.patpat.plugin.packet.handler.IPacketHandler;
import net.lopymine.patpat.plugin.util.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Nullable;

public class PatPacketHandler
implements IPacketHandler {
    private static final String PATPAT_C2S_PACKET_ID_V2 = StringUtils.modId("pat_entity_c2s_packet_v2");
    private static final String PATPAT_S2C_PACKET_ID_V2 = StringUtils.modId("pat_entity_s2c_packet_v2");
    private static final Set<IPatPacket> PAT_PACKET_HANDLERS = new LinkedHashSet<IPatPacket>();
    private static final Function<Player, Double> GET_INTERACT_DISTANCE = PatPacketHandler.getInteractDistanceFunction();
    private static final double CREATIVE_INTERACT_DISTANCE = 3.1;
    private static final double SURVIVOR_INTERACT_DISTANCE = 5.1;
    private final double patVisibilityRadius = (double)Bukkit.getServer().getViewDistance() * 16.0;

    private static Function<Player, Double> getInteractDistanceFunction() {
        try {
            Attribute attribute = Attribute.PLAYER_ENTITY_INTERACTION_RANGE;
            return player -> {
                AttributeInstance attr = player.getAttribute(attribute);
                if (attr == null) {
                    return player.getGameMode() == GameMode.CREATIVE ? 3.1 : 5.1;
                }
                return attr.getValue() + 0.1;
            };
        }
        catch (NoSuchFieldError e) {
            return player -> player.getGameMode() == GameMode.CREATIVE ? 3.1 : 5.1;
        }
    }

    public PatPacketHandler() {
        PAT_PACKET_HANDLERS.clear();
        PAT_PACKET_HANDLERS.add(new PatPacketV2());
        PAT_PACKET_HANDLERS.add(new PatPacketV1());
    }

    @Override
    public void handle(PatPlayer sender, ByteArrayDataInput buf) {
        PatPatPlugin plugin = PatPatPlugin.getInstance();
        Player senderPlayer = sender.getPlayer();
        if (!this.canHandle(senderPlayer)) {
            return;
        }
        if (senderPlayer.getGameMode() == GameMode.SPECTATOR || senderPlayer.isDead()) {
            return;
        }
        IPatPacket senderPacketHandler = sender.getPatPacketHandler();
        if (senderPacketHandler == null) {
            PatLogger.debug("Not found packet handler for player with PatPat version: %s", sender.getVersion());
            return;
        }
        Entity pattedEntity = senderPacketHandler.getPattedEntity(sender, buf);
        if (!(pattedEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)pattedEntity;
        if (livingEntity.isInvisible()) {
            return;
        }
        if (pattedEntity.equals((Object)senderPlayer)) {
            return;
        }
        if (senderPlayer.getWorld() != livingEntity.getWorld()) {
            return;
        }
        Location senderLocation = senderPlayer.getEyeLocation();
        double senderX = senderLocation.getX();
        double senderY = senderLocation.getY();
        double senderZ = senderLocation.getZ();
        BoundingBox entityBox = livingEntity.getBoundingBox();
        double interactDistance = GET_INTERACT_DISTANCE.apply(senderPlayer);
        double dx = Math.min(Math.abs(entityBox.getMaxX() - senderX), Math.abs(entityBox.getMinX() - senderX));
        if (dx > interactDistance) {
            return;
        }
        double dz = Math.min(Math.abs(entityBox.getMaxZ() - senderZ), Math.abs(entityBox.getMinZ() - senderZ));
        if (dz > interactDistance) {
            return;
        }
        double dy = Math.min(Math.abs(entityBox.getMaxY() - senderY), Math.abs(entityBox.getMinY() - senderY));
        if (dy > interactDistance) {
            return;
        }
        ArrayList<PatPlayer> nearbyPlayers = new ArrayList<PatPlayer>(pattedEntity.getNearbyEntities(this.patVisibilityRadius, this.patVisibilityRadius, this.patVisibilityRadius).stream().map(entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return player;
            }
            return null;
        }).filter(Objects::nonNull).map(PatPlayer::of).toList());
        if (pattedEntity instanceof Player) {
            Player player2 = (Player)pattedEntity;
            nearbyPlayers.add(PatPlayer.of(player2));
        }
        UUID senderUuid = sender.getUniqueId();
        HashMap packets = new HashMap();
        nearbyPlayers.forEach(player -> {
            UUID playerUuid = player.getUniqueId();
            if (playerUuid.equals(senderUuid)) {
                return;
            }
            IPatPacket packetHandler = player.getPatPacketHandler();
            if (packetHandler == null) {
                return;
            }
            PatPacket packet = packets.computeIfAbsent(packetHandler.getPacketHandlerId(), s -> packetHandler.getPacket(pattedEntity, (Entity)senderPlayer));
            PatLogger.debug("Sending out pat packet to %s with id %s and data %s", player.getName(), packet.channel(), Arrays.toString(packet.bytes()));
            player.sendPluginMessage((Plugin)plugin, packet.channel(), packet.bytes());
        });
    }

    @Nullable
    public static IPatPacket getPacketHandler(PatPlayer player) {
        for (IPatPacket packetHandler : PAT_PACKET_HANDLERS) {
            if (!packetHandler.canHandle(player)) continue;
            return packetHandler;
        }
        return null;
    }

    private boolean canHandle(Player sender) {
        UUID senderUuid = sender.getUniqueId();
        if (!sender.hasPermission(PatPatConfig.getInstance().getRateLimit().getPermissionBypass()) && !RateLimitManager.canPat(senderUuid)) {
            return false;
        }
        Set<UUID> uuids = PlayerListConfig.getInstance().getUuids();
        ListMode listMode = PatPatConfig.getInstance().getListMode();
        return switch (listMode) {
            default -> throw new IncompatibleClassChangeError();
            case ListMode.DISABLED -> true;
            case ListMode.WHITELIST -> uuids.contains(senderUuid);
            case ListMode.BLACKLIST -> !uuids.contains(senderUuid);
        };
    }

    @Override
    public String getIncomingPacketId() {
        return PATPAT_C2S_PACKET_ID_V2;
    }

    @Override
    public String getOutgoingPacketId() {
        return PATPAT_S2C_PACKET_ID_V2;
    }
}

