/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.packet.listener;

import com.google.common.io.ByteStreams;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.PatPatPlugin;
import net.lopymine.patpat.plugin.entity.PatPlayer;
import net.lopymine.patpat.plugin.packet.handler.IPacketHandler;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class PatPatPacketListener
implements PluginMessageListener {
    private final Map<String, IPacketHandler> handlers = new HashMap<String, IPacketHandler>();

    public void onPluginMessageReceived(@NotNull String s, @NotNull Player sender, byte[] bytes) {
        if (!this.isPatPatPacket(s)) {
            return;
        }
        PatPlayer patPlayer = PatPlayer.of(sender);
        IPacketHandler packetHandler = this.handlers.get(s);
        PatLogger.debug("Received packet with id %s from %s with data %s".formatted(s, sender.getName(), Arrays.toString(bytes)), new Object[0]);
        if (packetHandler == null) {
            return;
        }
        PatLogger.debug("Handling packet with " + String.valueOf(packetHandler.getClass()) + " from packet id " + packetHandler.getIncomingPacketId(), new Object[0]);
        packetHandler.handle(patPlayer, ByteStreams.newDataInput((byte[])bytes));
    }

    public void registerPacket(IPacketHandler handler, Messenger messenger) {
        this.handlers.put(handler.getIncomingPacketId(), handler);
        messenger.registerIncomingPluginChannel((Plugin)PatPatPlugin.getInstance(), handler.getIncomingPacketId(), (PluginMessageListener)this);
        messenger.registerOutgoingPluginChannel((Plugin)PatPatPlugin.getInstance(), handler.getOutgoingPacketId());
    }

    public boolean isPatPatPacket(String channel) {
        return channel.startsWith("patpat");
    }
}

