/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.plugin.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.lopymine.patpat.plugin.PatLogger;
import net.lopymine.patpat.plugin.PatPatPlugin;
import org.jetbrains.annotations.Nullable;

public final class ResourceUtils {
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final String FAILED_OPEN_JAR_FILE = "Failed to open `%s` in the jar file";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String loadFileFromJar(String filename) {
        try (InputStream inputStream = ((Object)((Object)PatPatPlugin.getInstance())).getClass().getClassLoader().getResourceAsStream(filename);){
            if (inputStream != null) {
                String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
            PatLogger.error("Failed to find `%s` in the jar file".formatted(filename), new Object[0]);
            return null;
        }
        catch (Exception e) {
            PatLogger.error(FAILED_OPEN_JAR_FILE.formatted(filename), e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Map<String, String> loadLangFromJar(String filename) {
        try (InputStream inputStream = ((Object)((Object)PatPatPlugin.getInstance())).getClass().getClassLoader().getResourceAsStream(filename);){
            if (inputStream != null) {
                Map map = (Map)GSON.fromJson((Reader)new InputStreamReader(inputStream), MAP_TYPE);
                return map;
            }
            PatLogger.error("Failed to find `%s` in the jar file".formatted(filename), new Object[0]);
            return null;
        }
        catch (JsonSyntaxException e) {
            PatLogger.error("Failed to read json from `%s` in the jar file".formatted(filename), (Exception)((Object)e));
            return null;
        }
        catch (IOException e) {
            PatLogger.error(FAILED_OPEN_JAR_FILE.formatted(filename), e);
        }
        return null;
    }

    @Nullable
    public static Map<String, String> loadLang(File file) {
        block8: {
            Map map;
            FileInputStream inputStream = new FileInputStream(file);
            try {
                map = (Map)GSON.fromJson((Reader)new InputStreamReader(inputStream), MAP_TYPE);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException e) {
                    PatLogger.error("Failed to read json from `%s` in the jar file".formatted(file.getName()), (Exception)((Object)e));
                    break block8;
                }
                catch (IOException e) {
                    PatLogger.error(FAILED_OPEN_JAR_FILE.formatted(file.getName()), e);
                }
            }
            ((InputStream)inputStream).close();
            return map;
        }
        return null;
    }

    private ResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

