/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.utils.VersionedThings;
import org.jetbrains.annotations.Nullable;

public class PlayerConfig {
    public static final Codec<PlayerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name").forGetter(PlayerConfig::getOptionalName), (App)VersionedThings.UUID_CODEC.optionalFieldOf("uuid").forGetter(PlayerConfig::getOptionalUuid)).apply((Applicative)instance, PlayerConfig::new));
    @Nullable
    private final String name;
    @Nullable
    private final UUID uuid;

    public PlayerConfig(Optional<String> name, Optional<UUID> uuid) {
        this.name = name.orElse(null);
        this.uuid = uuid.orElse(null);
    }

    public static PlayerConfig of(@Nullable String playerName, @Nullable UUID playerUuid) {
        return new PlayerConfig(Optional.ofNullable(playerName), Optional.ofNullable(playerUuid));
    }

    private Optional<String> getOptionalName() {
        return Optional.ofNullable(this.name);
    }

    private Optional<UUID> getOptionalUuid() {
        return Optional.ofNullable(this.uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerConfig)) {
            return false;
        }
        PlayerConfig that = (PlayerConfig)o;
        boolean b = that.name == null || Objects.equals(this.name, that.name);
        boolean b1 = that.uuid == null || Objects.equals(this.uuid, that.uuid);
        PatPatClient.LOGGER.debug("Comparing PlayerConfigs: [{} and {}] [{} and {}] - {}", this.name, that.name, this.uuid, that.uuid, b && b1);
        return b && b1;
    }

    public String toString() {
        return "PlayerConfig{name='" + this.name + "', uuid=" + String.valueOf(this.uuid) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uuid);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }
}

