/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.modmenu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.PatPat;

public class ModMenuTranslators {
    private static final PatLogger logger = PatPat.LOGGER.extend("ModMenuTranslators");
    private static final List<String> TRANSLATOR_KEY = List.of("Translator");
    private List<String> translators = new ArrayList<String>();
    private static ModMenuTranslators instance;

    private ModMenuTranslators() {
        Optional modContainer = FabricLoader.getInstance().getModContainer("patpat");
        if (modContainer.isEmpty()) {
            logger.warn("Failure to get mod container!", new Object[0]);
            return;
        }
        CustomValue translatorsSection = ((ModContainer)modContainer.get()).getMetadata().getCustomValue("translators");
        if (translatorsSection == null) {
            logger.warn("Failure to get translators section from fabric.mod.json!", new Object[0]);
            return;
        }
        ArrayList translatorsList = new ArrayList();
        translatorsSection.getAsObject().forEach(entry -> translatorsList.add((String)entry.getKey() + " - " + ((CustomValue)entry.getValue()).getAsString() + " (Translator)"));
        this.translators = Collections.unmodifiableList(translatorsList);
    }

    public static ModMenuTranslators getInstance() {
        if (instance == null) {
            instance = new ModMenuTranslators();
        }
        return instance;
    }

    public List<String> getTranslators() {
        return this.translators;
    }
}

