/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.packet.s2c;

import java.util.UUID;
import net.lopymine.patpat.packet.PatPatPacketType;
import net.lopymine.patpat.packet.S2CPatPacket;
import net.lopymine.patpat.utils.IdentifierUtils;
import net.lopymine.patpat.utils.WorldUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class PatEntityS2CPacket
implements S2CPatPacket<PatEntityS2CPacket> {
    public static final String PACKET_ID = "pat_entity_s2c_packet";
    public static final PatPatPacketType<PatEntityS2CPacket> TYPE = new PatPatPacketType<PatEntityS2CPacket>(IdentifierUtils.modId("pat_entity_s2c_packet"), PatEntityS2CPacket::new);
    private final UUID pattedEntityUuid;
    private final UUID whoPattedUuid;

    public PatEntityS2CPacket(class_1297 pattedEntity, class_1297 whoPattedEntity) {
        this.pattedEntityUuid = pattedEntity.method_5667();
        this.whoPattedUuid = whoPattedEntity.method_5667();
    }

    public PatEntityS2CPacket(class_2540 buf) {
        this.pattedEntityUuid = buf.method_10790();
        this.whoPattedUuid = buf.method_10790();
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10797(this.pattedEntityUuid);
        buf.method_10797(this.whoPattedUuid);
    }

    @Override
    @Nullable
    public class_1297 getPattedEntity(class_638 world) {
        return WorldUtils.getEntity(world, this.getPattedEntityUuid());
    }

    @Override
    @Nullable
    public class_1297 getWhoPattedEntity(class_638 world) {
        return WorldUtils.getEntity(world, this.getWhoPattedUuid());
    }

    @Override
    public PatPatPacketType<PatEntityS2CPacket> getPatPatType() {
        return TYPE;
    }

    public UUID getPattedEntityUuid() {
        return this.pattedEntityUuid;
    }

    public UUID getWhoPattedUuid() {
        return this.whoPattedUuid;
    }
}

