/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.client.config.resourcepack.ListMode;
import net.lopymine.patpat.common.Version;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.server.config.sub.PatPatServerRateLimitConfig;
import net.lopymine.patpat.utils.CodecUtils;
import net.lopymine.patpat.utils.ConfigUtils;

public class PatPatServerConfig {
    public static final Codec<PatPatServerConfig> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("debug", false, Codec.BOOL, PatPatServerConfig::isDebugModeEnabled), CodecUtils.option("version", Version.SERVER_CONFIG_VERSION, Version.CODEC, PatPatServerConfig::getVersion), CodecUtils.option("listMode", ListMode.DISABLED, ListMode.CODEC, PatPatServerConfig::getListMode), CodecUtils.option("rateLimit", PatPatServerRateLimitConfig.getNewInstance(), PatPatServerRateLimitConfig.CODEC, PatPatServerConfig::getRateLimitConfig)).apply((Applicative)inst, PatPatServerConfig::new));
    private static final PatLogger LOGGER = PatPat.LOGGER.extend("Config");
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("patpat.json5").toFile();
    private static PatPatServerConfig INSTANCE;
    private boolean debugModeEnabled;
    private Version version;
    private ListMode listMode;
    private PatPatServerRateLimitConfig rateLimitConfig;

    private PatPatServerConfig() {
        throw new IllegalArgumentException();
    }

    public static PatPatServerConfig getInstance() {
        return INSTANCE == null ? PatPatServerConfig.reload() : INSTANCE;
    }

    public static PatPatServerConfig reload() {
        INSTANCE = PatPatServerConfig.read();
        return INSTANCE;
    }

    public static Supplier<PatPatServerConfig> getNewInstance() {
        return () -> CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static PatPatServerConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public ListMode getListMode() {
        return this.listMode;
    }

    public PatPatServerRateLimitConfig getRateLimitConfig() {
        return this.rateLimitConfig;
    }

    public PatPatServerConfig(boolean debugModeEnabled, Version version, ListMode listMode, PatPatServerRateLimitConfig rateLimitConfig) {
        this.debugModeEnabled = debugModeEnabled;
        this.version = version;
        this.listMode = listMode;
        this.rateLimitConfig = rateLimitConfig;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setListMode(ListMode listMode) {
        this.listMode = listMode;
    }
}

