/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.config.sub;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.lopymine.patpat.common.config.time.Time;
import net.lopymine.patpat.utils.CodecUtils;

public class PatPatServerRateLimitConfig {
    public static final String STANDARD_PERMISSION = "patpat.ratelimit.bypass";
    public static final Codec<PatPatServerRateLimitConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("enable", false, Codec.BOOL, PatPatServerRateLimitConfig::isEnabled), CodecUtils.option("tokenLimit", 20, Codec.INT, PatPatServerRateLimitConfig::getTokenLimit), CodecUtils.option("tokenIncrement", 1, Codec.INT, PatPatServerRateLimitConfig::getTokenIncrement), CodecUtils.option("tokenIncrementInterval", Time.of("1sec"), Time.CODEC, PatPatServerRateLimitConfig::getTokenIncrementInterval), CodecUtils.option("permissionBypass", STANDARD_PERMISSION, Codec.STRING, PatPatServerRateLimitConfig::getPermissionBypass)).apply((Applicative)instance, PatPatServerRateLimitConfig::new));
    private boolean enabled;
    private int tokenLimit;
    private int tokenIncrement;
    private Time tokenIncrementInterval;
    private String permissionBypass;

    public static Supplier<PatPatServerRateLimitConfig> getNewInstance() {
        return () -> CodecUtils.parseNewInstanceHacky(CODEC);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTokenLimit() {
        return this.tokenLimit;
    }

    public int getTokenIncrement() {
        return this.tokenIncrement;
    }

    public Time getTokenIncrementInterval() {
        return this.tokenIncrementInterval;
    }

    public String getPermissionBypass() {
        return this.permissionBypass;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTokenLimit(int tokenLimit) {
        this.tokenLimit = tokenLimit;
    }

    public void setTokenIncrement(int tokenIncrement) {
        this.tokenIncrement = tokenIncrement;
    }

    public void setTokenIncrementInterval(Time tokenIncrementInterval) {
        this.tokenIncrementInterval = tokenIncrementInterval;
    }

    public void setPermissionBypass(String permissionBypass) {
        this.permissionBypass = permissionBypass;
    }

    public PatPatServerRateLimitConfig(boolean enabled, int tokenLimit, int tokenIncrement, Time tokenIncrementInterval, String permissionBypass) {
        this.enabled = enabled;
        this.tokenLimit = tokenLimit;
        this.tokenIncrement = tokenIncrement;
        this.tokenIncrementInterval = tokenIncrementInterval;
        this.permissionBypass = permissionBypass;
    }
}

