/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.modmenu.clothconfig;

import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientFunConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientMainConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientMultiplayerConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientResourcePacksConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientSoundsConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientVisualConfig;
import net.lopymine.patpat.utils.ModMenuUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ClothConfigConfigurationScreen {
    public static final Function<Boolean, class_2561> ENABLED_OR_DISABLED_FORMATTER = ModMenuUtils.getEnabledOrDisabledFormatterColored();
    public static final class_2583 NAME_STYLE = class_2583.field_24360.method_10982(Boolean.valueOf(true));

    private ClothConfigConfigurationScreen() {
        throw new IllegalStateException("Screen class");
    }

    public static class_437 createScreen(class_437 parent) {
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        PatPatClientConfig defConfig = PatPatClientConfig.getNewInstance().get();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)ModMenuUtils.getModTitle());
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        class_5250 title = ClothConfigConfigurationScreen.getCategoryName("general").method_27696(NAME_STYLE);
        ConfigCategory general = builder.getOrCreateCategory((class_2561)title);
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getMainGroup(entryBuilder, config.getMainConfig(), defConfig.getMainConfig()));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getResourcePackGroup(entryBuilder, config.getResourcePacksConfig(), defConfig.getResourcePacksConfig()));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getSoundGroup(entryBuilder, config.getSoundsConfig(), defConfig.getSoundsConfig()));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getVisualGroup(entryBuilder, config.getVisualConfig(), defConfig.getVisualConfig()));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getMultiplayerGroup(entryBuilder, config.getMultiPlayerConfig(), defConfig.getMultiPlayerConfig()));
        general.addEntry((AbstractConfigListEntry)ClothConfigConfigurationScreen.getFunGroup(entryBuilder, config.getFunConfig(), defConfig.getFunConfig()));
        builder.setSavingRunnable(config::saveAsync);
        return builder.build();
    }

    private static SubCategoryListEntry getMainGroup(ConfigEntryBuilder entryBuilder, PatPatClientMainConfig config, PatPatClientMainConfig defConfig) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)ClothConfigConfigurationScreen.getGroupName("main"));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("enable_mod"), config.isModEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("enable_mod")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isModEnabled()).setSaveConsumer(config::setModEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("debug_log_enabled"), config.isDebugLogEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("debug_log_enabled")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isDebugLogEnabled()).setSaveConsumer(config::setDebugLogEnabled).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getResourcePackGroup(ConfigEntryBuilder entryBuilder, PatPatClientResourcePacksConfig config, PatPatClientResourcePacksConfig defConfig) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)ClothConfigConfigurationScreen.getGroupName("custom_animations"));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("skip_outdated_animations_enabled"), config.isSkipOldAnimationsEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("skip_outdated_animations_enabled")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isSkipOldAnimationsEnabled()).setSaveConsumer(config::setSkipOldAnimationsEnabled).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getSoundGroup(ConfigEntryBuilder entryBuilder, PatPatClientSoundsConfig config, PatPatClientSoundsConfig defConfig) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)ClothConfigConfigurationScreen.getGroupName("sound"));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("enable_sounds"), config.isSoundsEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("enable_sounds")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isSoundsEnabled()).setSaveConsumer(config::setSoundsEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)ModMenuUtils.getOptionName("sounds_volume"), config.getSoundsVolume()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("sounds_volume")}).setDefaultValue(defConfig.getSoundsVolume()).setMin(0.0f).setMax(1.0f).setSaveConsumer(value -> config.setSoundsVolume((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getVisualGroup(ConfigEntryBuilder entryBuilder, PatPatClientVisualConfig config, PatPatClientVisualConfig defConfig) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)ClothConfigConfigurationScreen.getGroupName("visual"));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("hiding_nickname_enabled"), config.isHidingNicknameEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("hiding_nickname_enabled")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isHidingNicknameEnabled()).setSaveConsumer(config::setHidingNicknameEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("client_swing_hand_enabled"), config.isClientSwingHandEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("swing_hand_enabled")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isClientSwingHandEnabled()).setSaveConsumer(config::setClientSwingHandEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("server_swing_hand_enabled"), config.isServerSwingHandEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("swing_hand_enabled")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isServerSwingHandEnabled()).setSaveConsumer(config::setServerSwingHandEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)ModMenuUtils.getOptionName("animation_offset_x"), config.getAnimationOffsets().getX()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("animation_offset_x")}).setDefaultValue(defConfig.getAnimationOffsets().getX()).setMin(-5.0f).setMax(5.0f).setSaveConsumer(value -> config.getAnimationOffsets().setX((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)ModMenuUtils.getOptionName("animation_offset_y"), config.getAnimationOffsets().getY()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("animation_offset_y")}).setDefaultValue(defConfig.getAnimationOffsets().getY()).setMin(-5.0f).setMax(5.0f).setSaveConsumer(value -> config.getAnimationOffsets().setY((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)ModMenuUtils.getOptionName("animation_offset_z"), config.getAnimationOffsets().getZ()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("animation_offset_z")}).setDefaultValue(defConfig.getAnimationOffsets().getZ()).setMin(-5.0f).setMax(5.0f).setSaveConsumer(value -> config.getAnimationOffsets().setZ((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("camera_shacking"), config.isCameraShackingEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("camera_shacking")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isCameraShackingEnabled()).setSaveConsumer(config::setCameraShackingEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)ModMenuUtils.getOptionName("pat_weight"), config.getPatWeight()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("pat_weight")}).setDefaultValue(defConfig.getPatWeight()).setMin(0.0f).setMax(1.0f).setSaveConsumer(value -> config.setPatWeight((float)Math.round(value.floatValue() * 100.0f) / 100.0f)).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getMultiplayerGroup(ConfigEntryBuilder entryBuilder, PatPatClientMultiplayerConfig config, PatPatClientMultiplayerConfig defConfig) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)ClothConfigConfigurationScreen.getGroupName("multiplayer"));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("pat_me_enabled"), config.isPatMeEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("pat_me_enabled")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isPatMeEnabled()).setSaveConsumer(config::setPatMeEnabled).build());
        subcategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)ModMenuUtils.getOptionName("bypass_server_animations_priority_enabled"), config.isBypassServerResourcePackPriorityEnabled()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("bypass_server_animations_priority_enabled")}).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setDefaultValue(defConfig.isBypassServerResourcePackPriorityEnabled()).setSaveConsumer(config::setBypassServerResourcePackEnabled).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    private static SubCategoryListEntry getFunGroup(ConfigEntryBuilder entryBuilder, PatPatClientFunConfig config, PatPatClientFunConfig defConfig) {
        SubCategoryBuilder subcategory = entryBuilder.startSubCategory((class_2561)ClothConfigConfigurationScreen.getGroupName("fun"));
        subcategory.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)ModMenuUtils.getOptionName("pvp_mode"), PatPatClientFunConfig.PvpMode.class, (Enum)config.getPvpMode()).setTooltip(new class_2561[]{ModMenuUtils.getOptionDescription("pvp_mode")}).setEnumNameProvider(mode -> PatPatClientFunConfig.PvpMode.valueOf(mode.name().toUpperCase()).getText()).setDefaultValue((Enum)defConfig.getPvpMode()).setSaveConsumer(config::setPvpMode).build());
        subcategory.setExpanded(true);
        return subcategory.build();
    }

    public static class_5250 getCategoryName(String categoryId) {
        return ModMenuUtils.getName(ModMenuUtils.getCategoryKey(categoryId)).method_27696(NAME_STYLE);
    }

    public static class_5250 getGroupName(String groupId) {
        return ModMenuUtils.getName(ModMenuUtils.getGroupKey(groupId)).method_27696(NAME_STYLE);
    }
}

