/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.packet;

import java.util.UUID;
import lombok.Generated;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.client.config.list.PatPatClientPlayerListConfig;
import net.lopymine.patpat.client.config.resourcepack.ListMode;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.client.packet.PatPatClientNetworkManager;
import net.lopymine.patpat.client.packet.PatPatClientProxLibManager;
import net.lopymine.patpat.client.render.PatPatClientRenderer;
import net.lopymine.patpat.common.Version;
import net.lopymine.patpat.compat.flashback.FlashbackManager;
import net.lopymine.patpat.compat.replaymod.ReplayModManager;
import net.lopymine.patpat.packet.PatPacket;
import net.lopymine.patpat.packet.S2CPatPacket;
import net.lopymine.patpat.packet.c2s.HelloPatPatServerC2SPacket;
import net.lopymine.patpat.packet.c2s.PatEntityC2SPacket;
import net.lopymine.patpat.packet.c2s.PatEntityC2SPacketV2;
import net.lopymine.patpat.packet.s2c.HelloPatPatPlayerS2CPacket;
import net.lopymine.patpat.packet.s2c.PatEntityS2CPacket;
import net.lopymine.patpat.packet.s2c.PatEntityS2CPacketV2;
import net.lopymine.patpat.packet.s2c.SelfPatEntityS2CPacket;
import net.lopymine.patpat.packet.s2c.SelfPatEntityS2CPacketV2;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5520;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class PatPatClientPacketManager {
    public static final PatLogger LOGGER = PatPatClient.LOGGER.extend("PacketManager");
    private static Version currentPatPatServerPacketVersion = Version.PACKET_V1_VERSION;

    private PatPatClientPacketManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        PatPatClientNetworkManager.registerReceiver(HelloPatPatPlayerS2CPacket.TYPE, PatPatClientPacketManager::handleHelloPacket);
        PatPatClientNetworkManager.registerReceiver(PatEntityS2CPacket.TYPE, packet -> {
            PatPatClientProxLibManager.disableIfEnabledBecauseReceivedPacketFromServer();
            PatPatClientPacketManager.handlePatting(packet, FlashbackManager.isInReplay() || ReplayModManager.isInReplay());
        });
        PatPatClientNetworkManager.registerReceiver(PatEntityS2CPacketV2.TYPE, packet -> {
            PatPatClientProxLibManager.disableIfEnabledBecauseReceivedPacketFromServer();
            PatPatClientPacketManager.handlePatting(packet, FlashbackManager.isInReplay() || ReplayModManager.isInReplay());
        });
        PatPatClientNetworkManager.registerReceiver(SelfPatEntityS2CPacket.TYPE, packet -> PatPatClientPacketManager.handlePatting(packet, true));
        PatPatClientNetworkManager.registerReceiver(SelfPatEntityS2CPacketV2.TYPE, packet -> PatPatClientPacketManager.handlePatting(packet, true));
    }

    private static void handleHelloPacket(HelloPatPatPlayerS2CPacket packet) {
        LOGGER.debug("[PING] Received HelloPatPatPlayerS2CPacket packet! PatPat Mod/Plugin installed on the server!", new Object[0]);
        Version version = packet.getVersion();
        if (version.isInvalid()) {
            LOGGER.warn("Received invalid server version in hello packet!", new Object[0]);
            PatPatClientProxLibManager.disableIfNotInReplayModBecauseReceivedHelloPacketFromServer();
            PatPatClientPacketManager.setCurrentPatPatServerPacketVersion(Version.PACKET_V2_VERSION);
            return;
        }
        LOGGER.debug("Server PatPat Version: {}", version);
        if (version.isGreaterOrEqualThan(Version.PACKET_V2_VERSION)) {
            PatPatClientProxLibManager.disableIfNotInReplayModBecauseReceivedHelloPacketFromServer();
            PatPatClientPacketManager.setCurrentPatPatServerPacketVersion(Version.PACKET_V2_VERSION);
        }
        HelloPatPatServerC2SPacket pongPacket = packet.getPongPacket();
        LOGGER.debug("[PONG] Sending {} packet to the server...", pongPacket.getClass().getSimpleName());
        PatPatClientNetworkManager.sendPacketToServer(pongPacket);
    }

    public static void handlePatting(S2CPatPacket<?> packet, boolean replayModPacket) {
        LOGGER.debug("Started handling packet...", new Object[0]);
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        if (!config.getMainConfig().isModEnabled()) {
            LOGGER.debug("Packet declined, because mod is disabled", new Object[0]);
            return;
        }
        class_638 clientWorld = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        if (clientWorld == null || player == null) {
            LOGGER.debug("Packet declined, because world or player is null", new Object[0]);
            return;
        }
        class_1297 pattedEntity = packet.getPattedEntity(clientWorld);
        if (!(pattedEntity instanceof class_1309)) {
            LOGGER.debug("Packet declined, because patted entity in not LivingEntity", new Object[0]);
            return;
        }
        class_1309 pattedLivingEntity = (class_1309)pattedEntity;
        LOGGER.debug("Patted entity with name {} ", pattedEntity.method_5477().getString());
        class_1297 whoPattedEntity = packet.getWhoPattedEntity(clientWorld);
        if (whoPattedEntity == null) {
            LOGGER.debug("Packet declined, because who patted entity is null", new Object[0]);
            return;
        }
        LOGGER.debug("Who patted entity with name {}", whoPattedEntity.method_5477().getString());
        if (!(whoPattedEntity instanceof class_1657)) {
            LOGGER.debug("Packet declined, because who patted entity in not PlayerEntity", new Object[0]);
            return;
        }
        UUID pattedEntityUuid = pattedEntity.method_5667();
        UUID whoPattedUuid = whoPattedEntity.method_5667();
        if (PatPatClientPacketManager.isBlocked(whoPattedUuid)) {
            LOGGER.debug("Packet declined, because player uuid is blocked (/patpat-client list)", new Object[0]);
            return;
        }
        if (pattedEntityUuid.equals(player.method_5667()) && !config.getMultiPlayerConfig().isPatMeEnabled()) {
            LOGGER.debug("Packet declined, because option 'Pat Me' is disabled", new Object[0]);
            return;
        }
        PatPatClientRenderer.PatPacket patPacket = new PatPatClientRenderer.PatPacket(pattedLivingEntity, PlayerConfig.of(whoPattedEntity.method_5477().getString(), whoPattedUuid), player, replayModPacket);
        PatPatClientRenderer.registerServerPacket(patPacket);
        LOGGER.debug("Packet handled! Packet Data: {}", patPacket.toString());
    }

    public static boolean isBlocked(UUID playerUuid) {
        class_5520 socialManager = class_310.method_1551().method_31320();
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        PatPatClientPlayerListConfig playerListConfig = PatPatClientPlayerListConfig.getInstance();
        return config.getMultiPlayerConfig().getListMode() == ListMode.WHITELIST && !playerListConfig.getValues().containsKey(playerUuid) || config.getMultiPlayerConfig().getListMode() == ListMode.BLACKLIST && playerListConfig.getValues().containsKey(playerUuid) || socialManager.method_31392(playerUuid) || socialManager.method_31340(playerUuid);
    }

    public static PatPacket<class_3218, ?> getPatPacket(class_1297 pattedEntity) {
        if (PatPatClientPacketManager.getCurrentPatPatServerPacketVersion().isGreaterOrEqualThan(Version.PACKET_V2_VERSION)) {
            LOGGER.debug("Getting pat packet... Using V2 version", new Object[0]);
            return new PatEntityC2SPacketV2(pattedEntity);
        }
        LOGGER.debug("Getting pat packet... Using V1 version", new Object[0]);
        return new PatEntityC2SPacket(pattedEntity);
    }

    @Generated
    public static Version getCurrentPatPatServerPacketVersion() {
        return currentPatPatServerPacketVersion;
    }

    @Generated
    public static void setCurrentPatPatServerPacketVersion(Version currentPatPatServerPacketVersion) {
        PatPatClientPacketManager.currentPatPatServerPacketVersion = currentPatPatServerPacketVersion;
    }
}

