/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.keybinding;

import java.util.List;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.client.keybinding.KeybindingCombination;
import net.lopymine.patpat.client.keybinding.PressableKeybindingCombination;
import net.lopymine.patpat.client.manager.PatPatClientManager;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class PatPatKeybinding
extends class_304 {
    public static final KeybindingCombination DEFAULT_COMBINATION = PatPatKeybinding.getDefaultCombination();
    private final PressableKeybindingCombination combination = new PressableKeybindingCombination();
    private boolean binding;
    private boolean canStartBinding = true;

    @NotNull
    private static KeybindingCombination getDefaultCombination() {
        return new KeybindingCombination(class_3675.class_307.field_1668.method_1447(340), class_3675.class_307.field_1672.method_1447(1));
    }

    public PatPatKeybinding(KeybindingCombination patCombination) {
        super("patpat.keybinding.pat", -1, "PatPat");
        this.combination.setAttributeKey(patCombination.getAttributeKey());
        this.combination.setKey(patCombination.getKey());
    }

    public void startBinding() {
        this.combination.setAttributeKey(null);
        this.combination.setKey(null);
        this.binding = true;
        this.canStartBinding = false;
    }

    public boolean addBindingKey(class_3675.class_306 key) {
        if (this.isCanStartBinding()) {
            this.startBinding();
        }
        if (!this.isBinding()) {
            return true;
        }
        if (key.method_1444() == 256) {
            this.refreshPressedState();
            this.combination.setKey(null);
            this.combination.setAttributeKey(null);
            return true;
        }
        if (KeybindingCombination.isAttributeKey(key.method_1444())) {
            if (this.combination.isComplete()) {
                return true;
            }
            this.combination.setAttributeKey(key);
            return this.combination.isComplete();
        }
        this.combination.setKey(key);
        return true;
    }

    public void sendBindingKeys() {
        this.saveCombination();
        this.combination.setAll(false);
        this.binding = false;
        this.canStartBinding = true;
    }

    public void method_1422(class_3675.class_306 boundKey) {
        if (boundKey.equals((Object)this.method_1429())) {
            this.refreshPressedState();
            this.combination.setAttributeKey(DEFAULT_COMBINATION.getAttributeKey());
            this.combination.setKey(DEFAULT_COMBINATION.getKey());
            this.saveCombination();
        }
    }

    private void saveCombination() {
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        config.getMainConfig().setPatCombination(this.combination);
        config.saveAsync();
    }

    public boolean onKeyAction(class_3675.class_306 key, boolean pressed) {
        if (!this.combination.contains(key)) {
            return false;
        }
        if (this.combination.onlyOneKey()) {
            this.combination.set(key, pressed);
            this.method_23481(pressed);
            if (!pressed) {
                PatPatClientManager.setPatCooldown(0);
            }
            return this.method_1434();
        }
        if (!pressed) {
            this.combination.set(key, false);
            this.method_23481(false);
            PatPatClientManager.setPatCooldown(0);
            return false;
        }
        this.combination.set(key, true);
        boolean allPressedState = this.combination.allPressed();
        this.method_23481(allPressedState);
        return allPressedState && !KeybindingCombination.isAttributeKey(key.method_1444());
    }

    public boolean method_1427() {
        return this.combination.equals(DEFAULT_COMBINATION);
    }

    @NotNull
    public class_2561 method_16007() {
        return this.getFullTranslatedKeyMessage();
    }

    @NotNull
    public class_2561 getFullTranslatedKeyMessage() {
        return this.combination.getCombinationLocalizedComponent(!this.isBinding());
    }

    public void refreshPressedState() {
        List<class_3675.class_306> keys = this.combination.getKeys();
        keys.forEach(key -> {
            if (key.method_1442() == class_3675.class_307.field_1668) {
                this.combination.set((class_3675.class_306)key, class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.method_1444()));
            } else {
                this.combination.set((class_3675.class_306)key, GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)key.method_1444()) == 1);
            }
        });
        boolean allPressed = this.combination.allPressed();
        this.method_23481(allPressed);
    }

    public boolean isBinding() {
        return this.binding;
    }

    public boolean isCanStartBinding() {
        return this.canStartBinding;
    }
}

